<?php 
/**
 * FastBroadcast ist the main class of the API. It is a factory for other 
 * classes used by the library. If You recieve the objects from this class
 * there will be no need to direct include other files of the Library, 
 * because allrequired scriptfiles are loaded by the library. 
 * This is the main File of the FastBroadcast API
 * 
 * @package		FastBroadcast Calendar
 * @version		1.0.0
 * @copyright	Copyright (C) 2012 Horst Noreick, Inc. All rights reserved.
 * @license		GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

/**
 * FastBroadcast ist the main class of the API. It is a factory for other 
 * classes used by the library. If You recieve the objects from this class
 * there will bo no need to include other files of the Library, because all 
 * required scriptfiles are loaded by the library.
 * 
 * usage:
 * <code>
 * // Access to FastBroadcast API-Classes 
 * require_once dirname(__FILE__).'/lib/FastBroadcast.class.php';
 * 
 * // Get the HttpClient from the Factory
 * $httpClient = FastBroadcast::HttpClient();
 *
 * // combine params to a valid API-Request
 * $params = array(
 *		'scenes'		=> 'salsa',
 *		'catgroups'		=> 'event',
 *		'period'		=> 'week',
 *		'ccty'			=> 'Hamburg',
 *		'responsegroup'	=> 'medium');
 *
 * // Do the Request
 * $retcode = $httpClient->GetEventList( $params );
 *  
 * </code>
 */
class FastBroadcast
{
	/**
	 * Version 
	 */
	const VERSION 						= '1.0.0';	
	
	/**
	 * Constants for API-Access
	 */
	const HOST							= 'fastbroadcast.de';
	const RPC_PATH						= '/rpc.php?';
	const DOWNLOAD_PATH					= '/rpc.php?';	
	const IMAGE_PATH					= '/image.php?';		
	const TIMEOUT						= 7;
	
	/**
	 * the scheme unsually http://  
	 */	
	static public $scheme				= 'http://';

	/**
	 * A Translation function can be assigned with the Method
	 * RegisterTranslationFunction
	 */
	static protected $translation_function 	= null;

	/**
	 * The Application ID
	 */
	static private $app_id				= null;	
	
	/**
	 *  Array Handling
	 */
	static private $error				= array();
		
	/**
	 * returncodes
	 */
	const NO_DATA_FOUND = 100;		
	const SUCCESS 		= 0;
	const ERROR 		= -1;
	
	/**
	 * Constructor - This class is for static use only
	 */
	private function __construct()
	{
	
	}
	
	/**
	 * Clone - This class is for static use only
	 */
	private function __clone()
	{
	
	}
	
	/**
	 * Set the Application ID
	 * 
	 * @param	string	the application ID
	 * 
	 * @return	void
	 */
	static public function SetAPPID( $app_id )
	{
		self::$app_id = $app_id; 
	}
	
	/**
	 * APPID
	 * 
	 * @return	string	the application ID
	 */
	static public function APPID()
	{
		return self::$app_id;
	}

	/**
	 * Register a translation function
	 * 
	 * @param	mixed	the name of the function as a string
	 * 					or an array width classname and methodname 
	 * 					for static method calls
	 * 
	 * @return void		
	 */
	static public function RegisterTranslationFunction( $func )
	{
		self::$translation_function = $func;
	}
	
	/**
	 *	Translate a given String
	 *
	 * @param	string	the string to translate
	 * 
	 * @return	string	the translated string on success
	 * 					otherwise the given string
	 */
	static public function Translate( $str )
	{
		if ( !is_null( self::$translation_function)  )
			$str = call_user_func( self::$translation_function, $str );			
		
		return $str;
	}

	/**
	 * Create an Instance of FastBroadcastCalendarEvent
	 * 
	 * @return	object	instance of FastBroadcastCalendarEvent
	 */
	static public function CreateEvent()
	{
		require_once(dirname(__FILE__).'/FastBroadcastCalendarEvent.class.php');
		
		return new FastBroadcastCalendarEvent();
	}
	
	/**
	 * Setting an Error
	 * 
	 * @param	int		the retcode 
	 * @param	string	the message
	 * 
	 * @return	int 	the given retcode
	 */
	static public function SetError( $retcode, $message )
	{
		self::$error[] = array( 'retcode' => $retcode, 'message' => $message );
		
		return $retcode;
	}
	
	/**
	 * Get The Last Error
	 * 
	 * @param 	string	the errormessage
	 * 
	 * @return	int		retcode
	 */
	static public function GetLastError( &$message = '' )
	{
		$retcode = self::SUCCESS;
		if ( count( self::$error ) )
		{
			$error = end( self::$error );
			$message = $error['message'];
			$retcode = $error['retcode']; 
		}
		
		return $retcode;
	}	
	
	/**
	 * Get The Last Errormessage. This method shold only be used
	 * for small examples to easy access the message of an error
	 * 
	 * @return	string		message
	 */
	static public function GetLastErrorMessage()
	{
		$message = '';
		if ( count( self::$error ) )
		{
			$error = end( self::$error );
			$message = $error['message'];
		}
		
		return $message;
	}	
	
	/**
	 * Give back an Instance of the HttpClient
	 * 
	 * @return	object instance of class FastBroadcastHttpClient
	 */
	static public function HttpClient()
	{
		require_once(dirname(__FILE__).'/FastBroadcastHttpClient.class.php');

		return FastBroadcastHttpClient::GetInstance();
	}
	
}

