<?php
/**
 * This class is created from the FastBroadcastEvent class
 * 
 * @package		FastBroadcast Calendar
 * @version		1.0.0
 * @copyright	Copyright (C) 2012 Horst Noreick, Inc. All rights reserved.
 * @license		GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

/**
 * FastBroadcastPerson encapsulates the acces to the fields of the person arrays
 * inside of an event array. possible persons are locations, organizer, djs, 
 * guest.
 */
class FastBroadcastPerson
{
	/**
	 * the Person array
	 */
	protected $_person 	= null;
	
	/**
	 * Konstructor - there is no need to create an object from this class in 
	 * your code. Objects are created and given back from FastBroadcastEvent
	 * 
	 * @param 	array a person array from the event array
	 */
	function __construct( array $person = null )
	{
		$this->_person = $person;	
	}
	
	/**
	 *  Set the Person to access the data for a location or an organizer
	 *  
	 * @param 	array a person array from the event array 
	 */
	function SetPerson( array $person )
	{
		$this->_person = $person;
	}
	
	/**
	 * secure get a row of the array
	 * 
	 * @param 	string	the key to the value in the array
	 * 
	 * @return 	string 	the value matching to the key if the row exists
	 * 					otherwise an empty string
	 */
	public function get( $key )
	{
		return (isset($this->_person[$key]))? $this->_person[$key] : ''; 
	}

	/**
	 * Is there an id?
	 * 
	 * @return 	bool 	true if there is an id
	 */
	public function IsID()
	{
		return (isset($this->_person['id']));
	}
	
	/**
	 * The persons ID
	 * 
	 * @return 	int 	the persons id (required to get a persons-image form 
	 * 					the server for axample)
	 */
	public function ID()
	{
		return ($this->IsID())? $this->_person['id'] : ''; 
	}
	
	/**
	 * Is there a Full Name assigned
	 * 
	 * @return 	bool 	true if there is a fullname, otherwise false
	 */	
	public function IsFullname()
	{
		return (isset($this->_person['fullname']))? true : false;
	}
		
	/**
	 * The Fullname of the Person
	 * 
	 * @return 	string	The Fullname
	 */
	public function Fullname()
	{
		return ($this->IsFullname())? $this->_person['fullname'] : ''; 
	}

	
	/**
	 * is there a Name assigned to the Person
	 * 
	 * @return 	bool	true if there ist a valid name assigned
	 */	
	public function IsName()
	{
		return (isset($this->_person['name']) && $this->_person['name']);
	}
		
	/**
	 * The Persons Name
	 * 
	 * @return 	string	The Persons name
	 */
	public function Name()
	{
		return ($this->IsName())? $this->_person['name'] : ''; 
	}

	/**
	 * for naturally persons ther might ba first names assigned
	 * 
	 * @return	bool 	true if there is a valid first name assigned
	 */	
	public function IsFirstname()
	{
		return (isset($this->_person['firstname']) && $this->_person['firstname'])? true : false;
	}
		
	/**
	 * The Persons firstname
	 * 
	 * @return 	string	The firstname
	 * 
	 */
	public function Firstname()
	{
		return ($this->IsFirstname())? $this->_person['firstname'] : ''; 
	}
	
	/**
	 * for naturally persons ther might ba last names assigned
	 * 
	 * @return	bool 	true if there is a valid last name assigned
	 */	
	public function IsLastname()
	{
		return (isset($this->_person['lastname']) && $this->_person['lastname'])? true : false;
	}
		
	/**
	 * The Persons lastname
	 * 
	 * @return 	string	The lastname
	 * 
	 */
	public function Lastname()
	{
		return ($this->IsLastname())? $this->_person['lastname'] : ''; 
	}
	
	/**
	 * Is there a nickname assigned
	 * 
	 * @return 	bool	
	 */
	public function IsNickname()
	{
		return (isset($this->_person['nickname']) && $this->_person['nickname'])? true : false;
	}
		
	/**
	 * The Persons nickname
	 * 
	 * @return 	string	The nickname
	 */
	public function Nickname()
	{
		return ($this->IsLastname())? $this->_person['nickname'] : ''; 
	}
	
	/**
	 * Is there a title assigned
	 * 
	 * @return 	bool	
	 */
	public function IsTitle()
	{
		return (isset($this->_person['title']) && $this->_person['title'])? true : false;
	}
		
	/**
	 * The Title (Dr. Prof etc..)
	 * 
	 * @return	string 	the title
	 */
	public function Title()
	{
		return ($this->IsTitle())? $this->_person['title'] : ''; 
	}
	
	/**
	 * Is there a country assigned
	 * 
	 * @return 	bool	
	 */
	public function IsCountry()
	{
		return (isset($this->_person['country']) && $this->_person['country'])? true : false;
	}
		
	/**
	 * The Countra as an abbreviation (D - Deutschland..)
	 * 
	 * @return	string 	the title
	 */
	public function Country()
	{
		return ($this->IsCountry())? $this->_person['country'] : ''; 
	}
	
	/**
	 * Is there a phonenumber assigned
	 * 
	 * @return 	bool	
	 */
	public function IsPhone()
	{
		return (isset($this->_person['phone']) && $this->_person['phone'])? true : false;
	}
		
	/**
	 * The Phone number
	 * 
	 * @return	string 	the phonenumber
	 */
	public function Phone()
	{
		return ($this->IsPhone())? $this->_person['phone'] : ''; 
	}
	
	/**
	 * Is there a mobile phone number assigned
	 * 
	 * @return 	bool	
	 */
	public function IsMobile()
	{
		return (isset($this->_person['mobile']) && $this->_person['mobile'])? true : false;
	}
		
	/**
	 * The Title (Dr. Prof etc..)
	 * 
	 * @return	string 	the title
	 */
	public function Mobile()
	{
		return ($this->IsMobile())? $this->_person['mobile'] : ''; 
	}
	
	/**
	 * Is there a text assigned to the person
	 * 
	 * @return 	bool	
	 */
	public function IsText()
	{
		return (isset($this->_person['text']) && $this->_person['text'])? true : false;
	}
		
	/**
	 * A Text assigned to the Person
	 * 
	 * @return	string	the text
	 */	
	public function Text()
	{
		return ($this->IsText())? $this->_person['text'] : ''; 
	}
	
	/**
	 * Is there a street assigned
	 * 
	 * @return 	bool	
	 */
	public function IsStreet()
	{
		return (isset($this->_person['street']))? true : false;
	}
	
	/**
	 * A Street assigned to the person
	 * 
	 * @return 	string	the street
	 */
	public function Street()
	{
		return ($this->IsStreet())? $this->_person['street'] : ''; 
	}
	
	
	/**
	 * Is there a ZIP-code assigned
	 * 
	 * @return 	bool	
	 */
	public function IsZIP()
	{
		return (isset($this->_person['zip']))? true : false;
	}
		
	/**
	 * The ZIP-Code
	 * 
	 * @return 	string	the zip-code
	 */
	public function ZIP()
	{
		return ($this->IsZIP())? $this->_person['zip'] : ''; 
	}
	
	/**
	 * Is there a city assigned
	 * 
	 * @return 	bool	
	 */
	public function IsCity()
	{
		return (isset($this->_person['city']))? true : false;
	}
	
	/**
	 * The City assigne to the person
	 * 
	 * @return	string	the city 
	 */
	public function City()
	{
		return ($this->IsCity())? $this->_person['city'] : ''; 
	}


	/**
	 * Is there al Latitude assigned?
	 * 
	 * @return	bool true if there ist a latitude assigned
	 */
	public function IsLatitude()
	{
		return (isset($this->_person['latitude']))? true : false;
	}
	
	/**
	 * The latitude
	 * 
	 * @return	string	the latitude
	 */
	public function Latitude()
	{
		return ($this->IsLatitude())? $this->_person['latitude'] : ''; 
	}
	
	/**
	 * Is there al longitude assigned?
	 * 
	 * @return	bool true if there ist a longitude assigned
	 */
	public function IsLongitude()
	{
		return (isset($this->_person['longitude']))? true : false;
	}
	
	/**
	 * The latitude
	 * 
	 * @return	string	the longitude
	 */
	public function Longitude()
	{
		return ($this->IsLongitude())? $this->_person['longitude'] : ''; 
	}
	
	
	
	/**
	 * Are there Logos assigned to the person?
	 * 
	 * @param	int		the number of the logo
	 * 
	 * @return	bool	true if a logo with the given number exists
	 */
	public function IsLogo( $nr = 1 )
	{
		return (isset($this->_person[ 'logo_0'.$nr ]))? true : false;
	}
	
	/**
	 * The name of the existing logo. you can use this value to recieve
	 * the Logo Image from the server in a specified size
	 * 
	 * @param	int		the nr of the logo
	 * 
	 * @return	string	the name of the logo
	 */
	public function Logo( $nr = 1 )
	{
		return ($this->IsLogo($nr))? $this->_person['logo_0'.$nr] : ''; 
	}
	
	/**
	 * This Method creates an URL to access the logo from the FastBroadcast Server
	 * with the params width and height you can specify a rect the logo fits in 
	 * 
	 * @param	int		the number of the logo
	 * @param	int		the max width of the logo
	 * @param	int		the max height of the logo
	 * 
	 * @return	string	the url
	 */
	public function LogoURL( $nr = 1, $width = 0, $height = 0  )
	{
		return $this->ImageURL( 'logo_0'.$nr, $width, $height );
	}
	
	/**
	 * is there an url to the person homepage assigned?
	 * 
	 * @return	bool	tru if there ist an url assigned
	 */
	public function IsURL()
	{
		return (isset($this->_person['url']))? true : false;
	}
	
	/**
	 * the url to the person homepage
	 * 
	 * @return	string	the url
	 */
	public function URL()
	{
		return ($this->IsURL())? $this->_person['url'] : ''; 
	}
	
	/**
	 * does the specified field exist
	 * 
	 * @param 	string	the key
	 * 
	 * @return	bool	true if the key exists
	 */
	function IsField( $key )
	{
		return (isset($this->_person[$key]));		
	}
	
	/**
	 * This Method creates an URL to access the image from the FastBroadcast Server
	 * with the params width and height you can specify a rect the image fits in 
	 * 
	 * @param	string	the name of the image
	 * @param	int		the max width of the image
	 * @param	int		the max height of the image
	 * 
	 * @return	string	the image-url
	 */
	function ImageURL( $key, $width = 0, $height = 0  )
	{
		$url = '';
		if ( $this->IsField( $key ) )
		{
			$url 	= 'http://www.fastbroadcast.de/image.php?'
					. 'rpc_method=V001_Calendar_GetImage&amp;'
					. 'persid='. $this->ID(). '&amp;'
					. 'file='. $key;
	
			if ( $width )
				$url .= "&amp;width=$width";
			if ( $height )
				$url .= "&amp;height=$height";
		}
		return $url;				
	}
	
}

