<?php 
/**
 * Beispielanwendung für den Remotezugriff auf die API von FastBroadcast
 * 
 */

require_once dirname(__FILE__).'/../lib/FastBroadcast.class.php';


// Die Parameter für den Aufruf von GetEventList
// werden in ein Array geschrieben 
$params = array(
		'scenes'		=> 'salsa',
		'catgroups'		=> 'event',
		'period'		=> 'week',
		'ccty'			=> 'Hamburg',
		'responsegroup'	=> 'medium');

$httpClient = FastBroadcast::HttpClient();
// Das Array mit den Parametern wird an die GetEventList-Funktion übergeben
$retcode = $httpClient->GetEventList( $params );
if ( $retcode != FastBroadcast::SUCCESS )
{
	// Minimale Fehlerbehandlung für Demo
	die ( FastBroadcast::GetLastErrorMessage() );
} 

// Der Aufruf war erfolgreich und das Result kann verwendet werden 
$result = $httpClient->Result();

// FastBroadcast erzeugt ein Objekt der Klasse FastBroadcastCalendarEvent
// Die Eventklasse wird benötigt, um den Zugriff auf die zurückgegebenen 
// Events sicherer zu machen. Der Quellcode wird dadurch auch besser lesbar
$event = FastBroadcast::CreateEvent();

$url = str_ireplace( pathinfo( __FILE__, PATHINFO_FILENAME ), 
					'GetEvent_formatted', 
					$_SERVER['REQUEST_URI'] );
?>
<!DOCTYPE html>
<html dir="ltr" lang="de-DE">
	<head>
		<meta charset="UTF-8" />
		<title>FastBroadcast Beispiel</title>
		<style type="text/css" media="screen">
			* { margin: 0px; padding: 0px }
			body { font: 13px Helvetica, Arial, sans-serif; }
			.fb_eventlist { margin-left: 5px; }
			.fb_eventlist li { padding: 3px; }
			.fb_eventlist .summary { display: block; font-weight: bold; }		
			.fb_eventlist .info { display: block;  }
			.fb_eventlist .location_city { padding-right: 10px; }							
			.fb_eventlist .time { padding-right: 10px; }
			.fb_eventlist .location_name {  }						
		</style>		
	</head>
	<body>
		<ul class="fb_eventlist">
		<?php
			// Die ganze Eventliste wird gelesen.		
			foreach ( $result['eventlist'] as $event_array ) :
				// Die einzelnen Event-Arrays werden an ein Objekt 
				// der Klasse FastBroadcastEvent übergeben 
				$event->SetEvent( $event_array );
				$location = $event->Location();	
		?>
			<li>
				<span class="summary">
					<a href="<?php echo $url.'?eventid='.$event->Id().'&eventnr='.$event->Nr(); ?>">
						<?php echo $event->Summary();?>
					</a>
					</span>
				<span class="info">
					<?php if ( $location && $location->IsCity() ) : ?>
						<span class="location_city">[<?php echo $location->City(); ?>]</span>
					<?php endif; ?>
					
						<span class="time"><?php echo $event->Start('d.m. H:i').' - '.$event->End('H:i'); ?></span>

					<?php if ( $location && $location->IsName() ) : ?>							
						<span class="location_name"><?php echo $location->Name(); ?></span>

					<?php endif; ?>
				</span>
			</li>		
		<?php endforeach; ?>
		</ul>
	</body>
</html>