<?php 
/**
 * Beispielanwendung für den Remotezugriff auf die API von FastBroadcast
 * 
 */

require_once dirname(__FILE__).'/../lib/FastBroadcast.class.php';


// Die Parameter für den Aufruf von GetEventList
// werden in ein Array geschrieben 
$params = array(
		'scenes'		=> 'salsa',
		'catgroups'		=> 'event',
		'period'		=> 'week',
		'ccty'			=> 'Hamburg',
		'responsegroup'	=> 'medium');

$httpClient = FastBroadcast::HttpClient();
// Das Array mit den Parametern wird an die GetEventList-Funktion übergeben
$retcode = $httpClient->GetEventList( $params );
if ( $retcode != FastBroadcast::SUCCESS )
{
	// Minimale Fehlerbehandlung für Demo
	die ( FastBroadcast::GetLastErrorMessage() );
} 

// Der Aufruf war erfolgreich und das Result kann verwendet werden 
$result = $httpClient->Result();

?>
<!DOCTYPE html>
<html dir="ltr" lang="de-DE">
	<head>
		<meta charset="UTF-8" />
		<title>FastBroadcast Beispiel</title>
		<style type="text/css" media="screen">
			* { margin: 0px; padding: 0px }
			body { font: 13px Helvetica, Arial, sans-serif; }
			.fb_eventlist { margin-left: 5px; }
			.fb_eventlist li { padding: 3px; }
			.fb_eventlist .summary { display: block; font-weight: bold; }		
			.fb_eventlist .info { display: block;  }
			.fb_eventlist .location_city { padding-right: 10px; }							
			.fb_eventlist .time { padding-right: 10px; }
			.fb_eventlist .location_name {  }						
		</style>		
	</head>
	<body>
		<pre>
		<?php print_r( $result['eventlist'] );?>
		</pre>
	</body>
</html>