<?php 
/**
 * Beispielanwendung für den Remotezugriff auf die API von FastBroadcast
 * 
 */


require_once dirname(__FILE__).'/../lib/FastBroadcast.class.php';

// Die Parameter für den Aufruf von GetEventList
// werden in ein Array geschrieben 
$params = array(
		'eventid'	=> (int)$_REQUEST['eventid'],
		'eventnr'	=> (int)$_REQUEST['eventnr']);

// FastBroadcast erzeugt ein Object der Klasse FastBroadcastHttpClient.
// Diese Objekt wird benötigt für den Zugriff auf den FastBroadcast Server
$httpClient = FastBroadcast::HttpClient();

// Das Array mit den Parametern wird an die GetEvent-Funktion übergeben
$retcode = $httpClient->GetEvent( $params );
if ( $retcode != FastBroadcast::SUCCESS )
{
	// Minimale Fehlerbehandlung für Demo
	die ( FastBroadcast::GetLastErrorMessage() );
} 

// Der Aufruf war erfolgreich und das Result kann verwendet werden 
$result = $httpClient->Result();


// Die Klasse FastBroadcastCalendarEvent ist eine Kapselung für die Events,
// die im returnwert als array vorliegen. Jeder Tabellenwert muss vor der 
// Verwendung mit isset auf Existenz überprüft werden, weil je nach 
// 'responsegroup' mehr oder weniger Felder vom Server geliefert werden 
$event = FastBroadcast::CreateEvent();
$event->SetEvent( $result['event'] );

?>
<!DOCTYPE html>
<html dir="ltr" lang="de-DE">
	<head>
		<meta charset="UTF-8" />
		<title>FastBroadcast Beispiel</title>
		<style type="text/css" media="screen">
			* { margin: 0px; padding: 0px }
			body { font: 13px Helvetica, Arial, sans-serif; }
			table td { vertical-align: top; padding-bottom: 4px; }
			table th { vertical-align: top; padding-right: 10px; text-align: right; padding-bottom: 4px; }
			.fb_event { width: 800px; margin-top: 10px; margin-left: 30px;}			
		</style>		
	</head>
	<body>
		<table class="fb_event" cellspacing="0" cellpadding="0">
		<tr>
			<th>EventID:</th>
			<td><?php echo $event->Id();?></td>
		</tr>
			<th>EventNr:</th>
			<td><?php echo $event->Nr();?></td>
		</tr>

		<tr>
			<th>Titel:</th>
			<td><?php echo $event->Summary();?></td>
		</tr>
		<tr>
			<th>Slogan:</th>
			<td><?php echo $event->Slogan();?></td>
		</tr>
		<tr>
			<th>Start:</th>
			<td><?php echo $event->Start('d.m. H:i');?></td>
		</tr>
		<tr>
			<th>End:</th>
			<td><?php echo $event->End('d.m. H:i');?></td>
		</tr>
		<tr>
			<th>Szene:</th>
			<td><?php echo $event->Scene();?></td>
		</tr>
		<tr>
			<th>Kategorie:</th>
			<td><?php echo $event->Category();?></td>
		</tr>
		<tr>
			<th>Aufrufe:</th>
			<td><?php echo $event->Hits();?></td>
		</tr>
		<tr>
			<th>Created:</th>
			<td><?php echo $event->Created('d.m. H:i');?></td>
		</tr>
		<tr>
			<th>Created by:</th>
			<td><?php echo $event->CreatedBy();?></td>
		</tr>
		<tr>
			<th>Modified:</th>
			<td><?php echo $event->Modified('d.m. H:i');?></td>
		</tr>
		<tr>
			<th>Modified by:</th>
			<td>
				<?php echo $event->ModifiedBy();?>
			</td>
		</tr>
		<tr>
			<th>Description:</th>
			<td>
				<?php echo $event->Description();?>
			</td>
		</tr>
		<tr>
			<th>Bild-URL:</th>
			<td>
				<?php echo $event->ImageURL();?>
			</td>
		</tr>
		<tr>
			<th>Bild:</th>
			<td>
				<?php echo $event->ImageTag( 0, 200 );?>
			</td>
		</tr>

		<tr>
			<th>Location:</th>
			<td>
				<?php $person = $event->Location();?>
				<table>
					<tr>
						<th>LocationID:</th>
						<td>
							<?php echo $person->ID();?>
						</td>
					</tr>
					<tr>
						<th>Voller Name:</th>
						<td>
							<?php echo $person->FullName();?>
						</td>
					</tr>
					<tr>
						<th>Street:</th>
						<td>
							<?php echo $person->Street();?>
						</td>
					</tr>
					<tr>
						<th>Postleitzahl:</th>
						<td>
							<?php echo $person->ZIP();?>
						</td>
					</tr>
					<tr>
						<th>Stadt:</th>
						<td>
							<?php echo $person->City();?>
						</td>
					</tr>
					<tr>
						<th>Land:</th>
						<td>
							<?php echo $person->Country();?>
						</td>
					</tr>

				
				
				</table>
			</td>
		</tr>

		<tr>
			<th>Veranstalter:</th>
			<td>
				<?php $person = $event->Organizer();?>
				<table>
					<tr>
						<th>LocationID:</th>
						<td>
							<?php echo $person->ID();?>
						</td>
					</tr>
					<tr>
						<th>Voller Name:</th>
						<td>
							<?php echo $person->FullName();?>
						</td>
					</tr>
					<tr>
						<th>Street:</th>
						<td>
							<?php echo $person->Street();?>
						</td>
					</tr>
					<tr>
						<th>Postleitzahl:</th>
						<td>
							<?php echo $person->ZIP();?>
						</td>
					</tr>
					<tr>
						<th>Stadt:</th>
						<td>
							<?php echo $person->City();?>
						</td>
					</tr>
					<tr>
						<th>Land:</th>
						<td>
							<?php echo $person->Country();?>
						</td>
					</tr>

				
				
				</table>
			</td>
		</tr>


		
		</table>				
	</body>
</html>