<?php 
/**
 * Beispielanwendung für den Remotezugriff auf die API von FastBroadcast
 * 
 */

require_once dirname(__FILE__).'/../lib/FastBroadcast.class.php';

// Die Parameter für den Aufruf von GetEventList
// werden in ein Array geschrieben 
$params = array(
		'eventid'	=> (int)$_REQUEST['eventid'],
		'eventnr'	=> (int)$_REQUEST['eventnr']);

// FastBroadcast erzeugt ein Object der Klasse FastBroadcastHttpClient.
// Diese Objekt wird benötigt für den Zugriff auf den FastBroadcast Server
$httpClient = FastBroadcast::HttpClient();

// Das Array mit den Parametern wird an die GetEvent-Funktion übergeben
$retcode = $httpClient->GetEvent( $params );
if ( $retcode != FastBroadcast::SUCCESS )
{
	// Minimale Fehlerbehandlung für Demo
	die ( FastBroadcast::GetLastErrorMessage() );
} 

// Der Aufruf war erfolgreich und das Result kann verwendet werden 
$result = $httpClient->Result();

?>
<!DOCTYPE html>
<html dir="ltr" lang="de-DE">
	<head>
		<meta charset="UTF-8" />
		<title>FastBroadcast Beispiel</title>
	</head>
	<body>
		<pre>
		<?php print_r( $result['event'] );?>
		</pre>
	</body>
</html>