<?php 
/**
 * @package		NosCalendar
 * @version		1.0.0
 * @copyright	Copyright (C) 2012 Horst Noreick, Inc. All rights reserved.
 * @license		GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

require_once(JPATH_ROOT.DS.'components/com_noscalendar/helpers/NosCalendar.php');

class modNosCalendarHelper
{
	var $eventlist 	= null;
	var $message	= '';
	var $params		= null;	
	var $class		= ''; 
	var $time		= 0;
	

	
	function GetEventsOfDate( &$params, $date = '' )
	{

		$this->params = &$params;
		
		$this->class = $params->get('page', 'today');
		
		$calendar = NosCalendar::GetInstance();
		
		$cal = array();
		if ( defined('NOS_FACEBOOK'))
			$this->SetFBCalParams( $cal );
		else
			$this->SetCalParams( $cal, $params );
		
		$cal['period'] 		= 'day';

		$time = time();
		if ( $date )
		{
			list( $year, $month, $day ) = sscanf( $date, '%4d.%2d.%2d');
			$time = mktime(0,0,0,$month, $day, $year);			
		}
		
		$cal['date'] 		= date( "Y-m-d", $time );	
		$this->time = $time;	
			
		$retcode = $calendar->GetEventList( $cal, $this->eventlist );
		switch ( $retcode )
		{
		case NOS_NO_DATA_FOUND:
			$this->eventlist = array();
			$this->message = JText::_('TID_KEINE_EVENTS_IM_KALENDER');
			break;
		default:
		
		}

		
		return $retcode;
	}

	
	function SetFBCalParams( &$cal )
	{
		$calendar = NosCalendar::GetInstance();

		$cal['country'] 	= $calendar->GetParam( 'country' );
		$cal['catgroups'] 	= $calendar->GetParam( 'catgroups' );		
		$cal['selection']	= $calendar->GetParam( 'selection' );
		
		switch ( $cal['selection'] )
		{
		case 'pool':
			$cal['pool'] 	= $calendar->GetParam( 'pool' ); 		// nicht durch url-param ueberschreiben
			$calendar->AppendGeoSelectionFields( $cal );
			break;		

		case 'scene':
			$cal['scenes'] 	= $calendar->GetParam( 'scene');			
			$calendar->AppendGeoSelectionFields( $cal );			
			break;	
				
		case 'organizer':
			$cal['organizerid']	= $calendar->GetParam( 'organizerid' );
			break;
			
		case 'location':
			$cal['locationid']	= $calendar->GetParam( 'locationid' );
			break;					
		}			
	}
	
	
	function SetCalParams( &$cal, &$params )
	{
		$calendar = NosCalendar::GetInstance();

		$cal['country'] 	= $params->get('country' );
		if ( !$cal['country'] )					
			$cal['country'] 		= $calendar->GetParam( 'country' );

		$cal['catgroups'] = $params->get('catgroups' );
		if ( !$cal['catgroups'] )					
			$cal['catgroups'] = $calendar->GetParam( 'catgroups', false );	// nicht durch url-param ueberschreiben
/*			
		$cal['responsegroup'] = $params->get('responsegroup' );
		if ( $cal['responsegroup'] == 'small' )
		{
			switch ( $params->get('layout' ) )
			{
			case 'facebook':			
			case 'flyer':
				$cal['responsegroup'] = 'medium';
			}
		}
*/		
		$cal['responsegroup'] = 'medium';
		
		
		$cal['selection'] 		= $params->get('selection' );		
		if ( !$cal['selection'] )
			$cal['selection']	= $calendar->GetParam( 'selection', false ); 		// nicht durch url-param ueberschreiben
		
		switch ( $cal['selection'] )
		{
		case 'pool':
			$cal['pool'] 		= $params->get('pool' );		
			if ( !$cal['pool'] )
				$cal['pool'] 	= $calendar->GetParam( 'pool', false ); 		// nicht durch url-param ueberschreiben

				$calendar->AppendGeoSelectionFields( $cal );				
				
			break;		

		case 'scene':
			$cal['scenes'] 		= $params->get('scene' );		
			if ( !$cal['scenes'] )
				$cal['scenes'] 		= $calendar->GetParam( 'scene', false ); 		// nicht durch url-param ueberschreiben

			$calendar->AppendGeoSelectionFields( $cal );				
			break;	
				
		case 'organizer':
			$cal['organizerid'] = $params->get('organizerid' );
			if ( !$cal['organizerid'] )
				$cal['organizerid']	= $calendar->GetParam( 'organizerid' );
			break;
			
		case 'location':
			$cal['locationid'] = $params->get('locationid' );
			if ( !$cal['locationid'] )
				$cal['locationid']	= $calendar->GetParam( 'locationid' );
			break;					
		}			
		
		
	
	}
	
	function GetHighlights( &$params )
	{
		$this->params = &$params;
		$this->class .= ' highlight';		
		$calendar = NosCalendar::GetInstance();

		$cal = array();
		if ( defined('NOS_FACEBOOK'))
			$this->SetFBCalParams( $cal );
		else
			$this->SetCalParams( $cal, $params );
				
		
		if ( !isset($cal['date']))		
			$cal['date'] 		= date( "Y-m-d", time() );		
		$cal['state'] 		= 'highlight';

		$cal['limit'] 		= $params->get('limit', '10' );
							
		$retcode = $calendar->GetEventList( $cal, $this->eventlist );
		switch ( $retcode )
		{
		case NOS_NO_DATA_FOUND:
			$this->eventlist = array();
			$this->message = JText::_('Keine Workshops im System');
			break;
		default:
		
		}
		
	}
	
/*	
	function GetTimetable( &$params, $clientid = 0 )
	{
		$this->params = &$params;
		$this->class .= ' workshop';		
		$calendar	= NosCalendar::GetInstance();
		
		$cal = array();
		if ( defined('NOS_FACEBOOK'))
			$this->SetFBCalParams( $cal, $params );
		else
			$this->SetCalParams( $cal, $params );

		if ( $clientid )
			$cal['personid'] = $clientid;
		
		if ( !isset($cal['date']))		
			$cal['date'] 	= date( "Y-m-d", time() );

		$cal['period'] 		= 'week';
		$cal['catgroups'] 	= $params->get('catgroups', 'lesson');		
		
		$retcode = $calendar->GetEventList( $cal, $this->eventlist );
		switch ( $retcode )
		{
		case NOS_NO_DATA_FOUND:
			$this->eventlist = array();
			$this->message = JText::_('Keine Workshops im System');
			break;
		default:
		
		}
		
	}
*/	
	function GetComing( &$params, $clientid = 0 )
	{
		$this->params = &$params;
		$this->class .= ' workshop';		
		$calendar = NosCalendar::GetInstance();
		
		$cal = array();
		if ( defined('NOS_FACEBOOK'))
			$this->SetFBCalParams( $cal );
		else
			$this->SetCalParams( $cal, $params );
		
		if ( $clientid )
			$cal['personid'] = $clientid;
		
		if ( !isset($cal['date']))		
			$cal['date'] 	= date( "Y-m-d", time() );

		$cal['limit'] 		= $params->get('limit', '10' );
		$cal['catgroups'] 	= $params->get('catgroups', 'workshop');		

		$retcode = $calendar->GetEventList( $cal, $this->eventlist );
		switch ( $retcode )
		{
		case NOS_NO_DATA_FOUND:
			$this->eventlist = array();
			$this->message = JText::_('Keine Workshops im System');
			break;
		default:
		
		}
	}
	
	function ShowCity()
	{
		return $this->params->get('show_city', '1');
	}
	function ShowSlogan()
	{
		return $this->params->get('show_slogan');
	}
	function Limit()
	{
		return $this->params->get('limit', '10');
	}
	function Title()
	{
		return $this->params->get('title', 'your title');
	}
	function ClassNames()
	{
		return $this->class;
	}
	function ImageWidth()
	{
		return $this->params->get('flyer_width', '180');	
	}
}
