<?php
/**
 * @package		NosCalendar
 * @version		1.0.0
 * @copyright	Copyright (C) 2012 Horst Noreick, Inc. All rights reserved.
 * @license		GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

// no direct access
defined('_JEXEC') or die('Restricted access');


if ( !defined('NOSPATH_CALENDAR') )
	define('NOSPATH_CALENDAR', JPATH_ROOT.'/components/com_noscalendar' );

if ( !defined('NOS_LIBRARY') )
	require_once (NOSPATH_CALENDAR.'/Nos/Nos.php');

require_once (dirname(__FILE__).'/helper.php');

require_once(JPATH_ROOT.'/components/com_noscalendar/helpers/FastBroadcast.class.php');
FastBroadcast::RegisterTranslationFunction( array('Nos','GetString') );


$doc = JFactory::getDocument();



$calendar = NosCalendar::GetInstance();

// Set the Itemid if not defined by the module
if ( !$params->get('itemid') )
	$params->set('itemid', $calendar->Itemid() );

	
$helper = new modNosCalendarHelper;

$retcode = 0;
$page = $params->get('page', 'today');

switch ( $page )
{
case 'today':	// Alle Events von Heute anzeigen
	$page = 'day';
	$retcode = $helper->GetEventsOfDate( $params );
	break;
	
case 'day':	// Alle Events eines bestimmten Tages (z.B. Silvester)
	$retcode = $helper->GetEventsOfDate( $params, $params->get('date') );
	break;
	
case 'highlight':// Alle als Highlight markierte Termine
	$retcode = $helper->GetHighlights( $params );
	break;
	
case 'coming':
	$retcode = $helper->GetComing( $params );
	break;
/*	
case 'client_workshop':
	$view = 'workshop';
	$clientid = $params->get('clientid' );		
	if ( !$clientid )
		$clientid = $calendar->GetParam( 'clientid', false ); 		// nicht durch url-param ueberschreiben
	$retcode = $helper->GetWorkshops( $params, $clientid );
	break;
*/

}



// Compress
$repeatings = $params->get('repeatings');
if ( $retcode == NOS_SUCCESS && $repeatings != 'show' )
{
	$no_of_events_in_list = count( $helper->eventlist );
	for ( $offset = 0; $offset < $no_of_events_in_list; $offset++ )	
	{
		for ( $i = $offset + 1; $i < $no_of_events_in_list; $i++ )			
		{
			if ( !isset($helper->eventlist[$i]['delete']) && $helper->eventlist[$i]['eventid'] == $helper->eventlist[$offset]['eventid'] )
			{
				if ( !isset( $helper->eventlist[$offset]['next'] ))
					$helper->eventlist[$offset]['next'] = array();
					
				$helper->eventlist[$offset]['next'][] = array( 'eventid' => $helper->eventlist[$i]['eventid'], 'eventnr' => $helper->eventlist[$i]['eventnr'], 'start' => $helper->eventlist[$i]['start'] ); 			
				$helper->eventlist[$i]['delete'] = true;
			}
		}
	}
	
	do 
	{
		$deleted = 0;
		for ( $i = 0; $i <= $no_of_events_in_list; $i++ )
		{
			if ( isset($helper->eventlist[$i]['delete']) )
			{
				unset($helper->eventlist[$i]);
				$deleted++;
			}
		}
	} while ( $deleted );
}



$e 				= FastBroadcast::CreateEvent();

// Embedding microdata from schema.org
$schema_org_state = $params->get('schema_org');
if ( $schema_org_state == 'use_global')
	$schema_org_state = $calendar->GetParam( 'schema_org' );
	
$schema_org 	= FastBroadcast::GetSemanticWeb( 'schema.org', ($schema_org_state == 'enabled') );
$e->SetSchemaOrg( $schema_org );

$schema_org->SetEvent( $e );

// Embedding microdata from hCalendar
$hcalendar_state 	= $params->get('hcalendar');
if ( $hcalendar_state == 'use_global' )
	$hcalendar_state 	= $calendar->GetParam( 'hcalendar' );
$hcalendar	 	= FastBroadcast::GetSemanticWeb( 'hcalendar', ($hcalendar_state == 'enabled') );
if ( $hcalendar_state == 'enabled' )
	$doc->addCustomTag( $hcalendar->link_profile() );
$hcalendar->SetEvent( $e );
	
NosSemanticWeb::SetPersonID( $calendar->GetParam( 'semanticweb_personid' ) );

// get the layoutpath
$layout 	= $params->get('layout', 'default');
$php_path 	= JModuleHelper::getLayoutPath('mod_noscalendar', $layout );

// Embed css-file if required 
if ( $params->get('addstylesheet', '1') )
{
	$css_path = str_replace( '.php', '.css' , $php_path );
	if ( file_exists( $css_path )  )
	{
		$pos = strpos( $css_path, 'modules' );
		if ( $pos === false )
			$pos = strpos( $css_path, 'templates' );
			
		$css_path = substr( $css_path, $pos );

		$doc->addStyleSheet( $css_path );
	}
}	

// Load the template
require	$php_path;




