<?php 
/**
 * @package		NosCalendar
 * @version		1.0.0
 * @copyright	Copyright (C) 2012 Horst Noreick, Inc. All rights reserved.
 * @license		GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */ 

// no direct access
defined('_JEXEC') or die('Restricted access'); 

$itemid 		= $params->get('itemid');
$link_to 		= $params->get('link_to', 'event');
$image_style 	= $params->get('image_style');
$image_width 	= (int)$params->get('image_width');
$image_height 	= ($image_style == 'squared')? $image_width : 0;					
$line_1			= $params->get('line_1');
$line_2 		= $params->get('line_2');
$line_3 		= $params->get('line_3');
$module_width	= $params->get('module_width');

$style			= '';

$module_id = 'mod_noscalendar_' . $params->get('page');

?>

<?php
$css_module_width = '';
if ($module_width) 
	$css_module_width = 'width: '. $module_width.'px;'; 

$css_date = '';	
$css_line_margin = '';	
$css_line2_margin = '';
if ( $image_style && $image_width )
{
	$css_line_margin = 'margin-left: '. ($image_width + 5) . 'px;';
}
else
{
	$css_line2_margin 	= 'margin-left: 40px;';
	$css_date 			= 'display: inline-block; width: 40px;';
}
	
	
$style = <<<STYLE

#$module_id a {
	display: block;
	$css_module_width
	margin-bottom: 3px;
}

#$module_id .event { clear: both; }

#$module_id img {float: left; margin-top: 2px; margin-bottom: 2px;}

#$module_id .line_1 .date,
#$module_id .line_1 .time {	$css_date }

#$module_id .line_2 { $css_line2_margin }
#$module_id .line_3 { $css_line2_margin }
#$module_id .line_next { $css_line2_margin }	 

#$module_id .line_1,
#$module_id .line_2,
#$module_id .line_3,
#$module_id .line_next { 
	display: block;
	$css_line_margin
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;	
}

STYLE;

if ( $params->get('embed_layout') )
	JFactory::getDocument()->addStyleDeclaration( $style );

$e_next = null;	
?>

<div id="<?php echo $module_id; ?>" class="mod_noscalendar <?php echo $helper->ClassNames(); ?>">
	<?php 
		if ( $params->get('show_headline') && $helper->time )
		{
			echo '<div class="header">';
			$date = getdate( $helper->time );
			echo Nos::GetString('TID_HEUTE').': ' . Nos::GetString($date['weekday']) . ', ' . $date['mday'] . '. ' . Nos::GetString($date['month']) . ' ' . $date['year'];
			echo "</div>\r\n";
		}
	?>	
	<?php if (!empty($helper->eventlist)) : ?>
	
		<?php
			$row = 0;
			$toggler = 'even';
			foreach ($helper->eventlist as $event ) 
			{ 
				$e->SetEvent( $event );

				$toggler = ($toggler == 'even')? 'odd' : 'even';
				
				$class = 'event ' . $toggler;
				if ( $e->ClientState() )
					$class .= ' clientevent';
				
				$event['catgroups']='workshop,event';
					
				echo '<span class="'. $hcalendar->classname('vevent') . '" ' .$schema_org->init_event(). '>';
				echo '<a href="'.$calendar->EventURL( $e, $itemid, $link_to ).'" class="url ' . $class . ' clearfix" '. $schema_org->url(). '>';
								
								
//				echo '<a href="'.$calendar->EventURL( $e, $itemid, $link_to ).'" class="' . $class . ' clearfix" '. $microdata->init_event(). ' '. $microdata->url() .'>';				
					
				echo $schema_org->meta_startdate();
				echo $schema_org->meta_enddate();

				echo $hcalendar->dtstart();
				echo $hcalendar->dtend();
				
								
				// display the image			 
				if ( $image_style != '0' )
				{
					$imageurl 	= '';		
			
					if ( $e->ImageName())
					{
						$index = 0;
						$e->IsFlyer($index);
						$imageurl = $e->ImageURL( $index, $image_width, $image_height  );
					}
					if ( !$imageurl )
						$imageurl = JURI::Base() . 'modules/mod_noscalendar/images/no-icon.gif';
					echo '<span class="imgshell"><img width="' . $image_width . '" src="' . $imageurl . '" alt="" /></span>';					
				}
				
				// display Line 1
				if ( !empty($line_1) )
					echo '<span class="line_1">' . $e->RenderLine( $line_1 ) . '</span>';
	
				// display Line 2				
				if ( !empty($line_2) )
					echo '<span class="line_2">' . $e->RenderLine( $line_2 ) . '</span>';	

				// display Line 3				
				if ( !empty($line_3) )
					echo '<span class="line_3">' . $e->RenderLine( $line_3 ) . '</span>';	
					
				if ( $repeatings == 'hide_but_link' && $e->IsNext() )
				{
					// display the dates of next repetitions of the event
					
					if ( $e_next == null )
						$e_next = FastBroadcast::CreateEvent();

					echo '<span class="line_next">' . Nos::GetString('Weitere') . ':';
					$next 		= $e->Next();
					$no_of_next = count( $next );
					$max_next 	= 3;
																
					for ( $i = 0; $i < $no_of_next; $i++ )
					{
						if ( $i == $max_next )
						{
							echo ' ...';
							break;
						}
						$e_next->SetEvent( $next[$i] );

						echo $e_next->Start(' d.m.');
					}
					echo '</span>';
				}
								
					
				echo '</a>';
				
				echo '</span>';				
													
				if ( ++$row == $helper->Limit() )
						break;
				if ( $row < count($helper->eventlist)) 
					echo '<span class="separator">&nbsp;</span>';
			} 
		?>			
			
	<?php endif; ?>
</div>