<?php
/**
 * @package		NosCalendar
 * @version		1.0.0
 * @copyright	Copyright (C) 2012 Horst Noreick, Inc. All rights reserved.
 * @license		GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

defined('JPATH_BASE') or die;

class JFormFieldNosSeparator extends JFormField
{
	protected $type = 'NosSeparator';

	protected function getInput()
	{
		return '';
	}

	/*
	 * Die Übergabe von Formatierungen per style funktioniert in neueren
	 *  Versionen nicht mehr. Es dürfen nur noch Formatierungen aus Joomla-Klassen
	 *  verwendet werden, die in der xml-datei im field-tag übergeben werden
	 *  BSP: <field ... class="hide" />
	 *  Um ein Label ohne Eingabefeld zu erhalten, muss ich "hide" übergeben werden   
	 */
	public function getLabel() {
    	 return '<span style="padding-top: 10px; font-weight:bold; font-size:1.2em;">' . parent::getLabel() . '</span>';
	}	
}
