<?php
defined('_JEXEC') or die;

define( 'COM_NOSCALENDAR_ADMIN_COMPONENT_DIR', dirname(__FILE__) );


// The Controller does nothing else when parent::display()
// so it don't neet an extra php.file
// In older Versions of Joomla the Controllers are inherited 
// from JController. Newer Versions must be inherited from
// JControllerLegacy that is why we check the existens and
// inherit form al self made JControllerLegacy class which 
// does nothing but it's easier to work with different 
// Versions of Joomla in this way!



if ( !class_exists('JControllerLegacy'))
{
	jimport('joomla.application.component.controller');
	require_once COM_NOSCALENDAR_ADMIN_COMPONENT_DIR.'/helpers/Nos.JControllerLegacy.php';
}	
	
class NosCalendarController extends JControllerLegacy
{
	public function display($cachable = false, $urlparams = false)
	{
		parent::display();
		return $this;
	}
}



$version 	= new JVersion();
$view 		= '';
$task 		= '';
$controller = null;

// Set the default Title
JToolbarHelper::title('FastBroadcast-Calendar');


if ( $version->isCompatible('3.0.0') )
{
	// Access check.
	if (!JFactory::getUser()->authorise('core.manage', 'com_noscalendar')) {
		return JError::raiseWarning(404, JText::_('JERROR_ALERTNOAUTHOR'));
	}

	// Joomla 3X
	$app = JFactory::getApplication();
	$view 		= $app->input->get('view');
	$task 		= $app->input->get('task');
	
	// Get the controller
	$controller = JControllerLegacy::getInstance('NosCalendar');
}
else if ( $version->isCompatible('1.6.0') )
{
	// Joomla 1.6.X - 2.5.X

	$view 		= JRequest::getCmd('view');
	$task 		= JRequest::getCmd('task');
	
	// Get the controller
	$controller = JController::getInstance('NosCalendar');
}
else 
{
	// Joomla 1.5.X
	$view 		= JRequest::getCmd('view');
	$task 		= JRequest::getCmd('task');
	
	jimport('joomla.application.component.view');
	jimport('joomla.application.component.model');
	
	// J15 - Der Controller muss mit seinem Name aufgerufen werden!
	$controller = new NosCalendarController();
}

// Set to default-view on start-up 
if ( empty($view) )
	JRequest::setVar('view', 'main');



// Execute the task.
$controller->execute( $task );
$controller->redirect();
	