<?php 
/**
 * @package		NosCalendar
 * @version		1.0.0
 * @copyright	Copyright (C) 2012 Horst Noreick, Inc. All rights reserved.
 * @license		GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

defined('_JEXEC') or die('Restricted access');
 
error_reporting(E_ALL);

define( 'NOS_LIBRARY', true );

define( 'NOSPATH_BASE', dirname(__FILE__) );

define( 'NOSPATH_DATABASE', NOSPATH_BASE );
define( 'NOSPATH_DATABASE_TABLES', NOSPATH_BASE );

define( 'NOSPATH_LANGUAGE', NOSPATH_BASE );

if (!defined('DS'))
	define('DS',"\\");

	

define( 'NOS_ERROR', -1 );
define( 'NOS_SUCCESS', 0 );
define( 'NOS_NO_DATA_FOUND', 100 );
	
require_once NOSPATH_BASE.DS.'NosError.php';

class Nos
{
	static function CreateDatabase( $host='', $user='', $pass='', $db = '', $prefix = '')
	{
		require_once NOSPATH_BASE.DS.'NosDatabase.php';
		require_once NOSPATH_BASE.DS.'NosTime.php';

		if ( defined('_JEXEC') )
		{
			$config	=& JFactory::getConfig();
			$host = 	$config->getValue('config.host');
			$user = 	$config->getValue('config.user');
			$pass = 	$config->getValue('config.password');
			$db = 		$config->getValue('config.db');			
			$prefix = 	$config->getValue('config.dbprefix');	
		}		
		return new NosDatabase( $host, $user, $pass, $db, $prefix );
	}
	
	static function GetDatabase() 
	{
		static $db = null;
		if ( !$db )
			$db = Nos::CreateDatabase();
		return $db;		
	}
	
	function CreateVEVENT()
	{
		require_once NOSPATH_BASE.DS.'NosVEVENT.php';
		require_once NOSPATH_BASE.DS.'NosTime.php';		
		return new NosVEVENT;
	}	
	
	static function DefaultLanguage()
	{
		return 'de';	
	}
	
	static function Route( $url )
	{
		if ( defined('_JEXEC') )
			return JRoute::_( $url );
	}
	
	static function GetString( $str, $lang = null)
	{
		if ( !$lang )
			$lang = Nos::DefaultLanguage();
		
		if ( defined('_JEXEC') )					
			$str = JText::_( $str );
			
		// TODO			
		return $str;
	}
	
}


?>