<?php 
/**
 * @package		NosCalendar
 * @version		1.0.0
 * @copyright	Copyright (C) 2012 Horst Noreick, Inc. All rights reserved.
 * @license		GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

defined('_JEXEC') or die('Restricted access');
 
defined( 'NOS_LIBRARY' ) or die( 'Restricted access' );

// zur Fehlerbehandlung werden bur diese 2 Funktionen ben�tigt. 
// Die Klasse NosError wird im weiteren Quellcode nicht ben�tigt



function NosSetLastError( $retcode, $message = '', $native = '' )
{
	return NosError::GetInstance()->SetLastError( $retcode, $message, $native );
}

function NosSetLastItemError( $retcode, $item, $message = '', $native = '' )
{
	return NosError::GetInstance()->SetLastItemError( $retcode, $item, $message, $native );
}

function NosGetLastError( &$message = null, &$native = null)
{
	return NosError::GetInstance()->GetLastError( $message, $native ); 
}

function NosGetErrorList()
{
	return NosError::GetInstance()->errorlist; 
}

function NosGetErrorListUTF8()
{
	$errorlist = NosError::Instance()->errorlist;
	$utf8list = array();
	foreach ( $errorlist as $e )
	{
		$utf8list[] = array( 'error' => $e['error'], 'item' => $e['item'], 'message' => utf8_encode($e['message']), 'native' => utf8_encode($e['native']) );
				
	}	
	return $utf8list;
}

class NosError
{
	var $errorlist 	= null;
	var $instance 	= null;
	
	function __construct()
	{
		$this->errorlist = array();
	}
	
	static function GetInstance()
	{
		static $instance = null;
		if ( !$instance )
			$instance = new NosError();
		return $instance;
	}
	
	function GetLastError( &$error = null )
	{
		$retcode = NOS_SUCCESS;
		$i = count( $this->errorlist );
		if ( $i )
		{
			$error 		= $this->errorlist[$i-1];
			$retcode 	= $error['error'];
		}
		return $retcode;
	}
	
	function SetLastError( $retcode, $message = '', $native = '' )
	{
		$this->errorlist[] = array( 'error' => $retcode, 'item' => '', 'message' => $message, 'native' => $native );		
		return $retcode;
	}
	
	function SetLastItemError( $retcode, $item, $message = '', $native = '' )
	{
		$this->errorlist[] = array( 'error' => $retcode, 'item' => $item, 'message' => $message, 'native' => $native );
		return $retcode;
	}	
	
}

?>