<?php 
/**
 * @package		NosCalendar
 * @version		1.0.0
 * @copyright	Copyright (C) 2012 Horst Noreick, Inc. All rights reserved.
 * @license		GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

defined('_JEXEC') or die('Restricted access');

defined( 'NOS_LIBRARY' ) or die( 'Restricted access' );
define('NOS_SECONDS_PER_DAY', 86400 );
define('NOS_SECONDS_PER_HOUR', 3600 );

class NosDate
{
	var $y;
	var $m;
	var $d;
	
	function __construct( $y=0, $m=0, $d=0 )
	{
		$this->Set($y,$m,$d);
	}
	
	function Increase( $val = 1 )
	{
		$t = mktime( 0, 0, 0, $this->m, $this->d, $this->y );
		$t += ( $val * NOS_SECONDS_PER_DAY )+ (12 * NOS_SECONDS_PER_HOUR);
		$a = getdate( $t );
		$this->y = $a['year'];
		$this->m = $a['mon'];
		$this->d = $a['mday'];
	}
	
	function Decrease( $val = 1 )
	{
		$t = mktime( 0, 0, 0, $this->m, $this->d, $this->y );
		$t -= ( $val * NOS_SECONDS_PER_DAY )+ (12 * NOS_SECONDS_PER_HOUR);
		$a = getdate( $t );
		$this->y = $a['year'];
		$this->m = $a['mon'];
		$this->d = $a['mday'];
	}
	
	function Set( $y=0, $m=0, $d=0 )
	{
		if ( $y && $m && $d )
		{
			$this->y = $y;
			$this->m = $m;
			$this->d = $d;
		}
		else
		{
			$a = getdate(time());
			$this->y = $a['year'];
			$this->m = $a['mon'];
			$this->d = $a['mday'];
		}
	}	
	
	function Get( &$y, &$m, &$d )
	{
		$y = $this->y;
		$m = $this->m;
		$d = $this->d;				
	}

}

//
// Helper f�r Zeitkonvertierungen
function CalTime_to_time( $caltime )
{
	list( $year, $month, $day, $hour, $minute, $second) = sscanf( $caltime, '%4d%2d%2dT%2d%2d%2d');
	return mktime($hour,$minute, $second, $month, $day, $year );
}

function time_to_DBTime( $time )
{
	return date( "Y-m-d H:i:s", $time );
}

function CalTime_to_DBTime( $caltime )
{
	list( $year, $month, $day, $hour, $minute, $second) = sscanf( $caltime, '%4d%2d%2dT%2d%2d%2d');
	return sprintf("%4d-%02d-%02d %02d:%02d:%02d", $year, $month, $day, $hour, $minute, $second );
}

function DBTime_to_CalTime( $dbtime )
{
	list( $year, $month, $day, $hour, $minute, $second) = sscanf( $dbtime, '%4d-%2d-%2d %2d:%2d:%2d');
	return sprintf("%4d%02d%02dT%02d%02d%02d", $year, $month, $day, $hour, $minute, $second );
}

function DBTime_to_time( $dbtime )
{
	list( $year, $month, $day, $hour, $minute, $second) = sscanf( $dbtime, '%4d-%2d-%2d %2d:%2d:%2d');
	return mktime($hour,$minute, $second, $month, $day, $year );
}

function SQL_BETWEEN( $period, $time, &$start, &$units = 0 )
{
	$date 	= getdate($time);
	$year	= $date['year'];
	$month	= $date['mon'];
	$day 	= $date['mday'];

	$end 	= 0;
	switch ($period)
	{
	case 'day':
		$start 	= mktime(0,0,0, $month, $day, $year );
		$end	= $start + (60*60*24)-1;
		$units	= 1;
		break;
	case 'week':
		$start 	= mktime(0,0,0, $month, $day, $year );
		$start  -= (Date('N', $start)-1)*60*60*24;
		$end	= $start + (60*60*24*7)-1;
		$units 	= 7;
		break;
	case 'month':
		$days 	= cal_days_in_month( CAL_GREGORIAN, $month, $year );
		$start 	= mktime(0,0,0, $month, 1, $year );
		$end	= $start + ($days*60*60*24)-1;
		$units = days;
		break;
	case 'month_plus':
		$days 	= cal_days_in_month( CAL_GREGORIAN, $month, $year );
		
		$start 	= mktime(0,0,0, $month, 1, $year );
		$days_before 	= (Date('N', $start)-1);
		$start -= $days_before*60*60*24;		

		$end	= mktime(23,59,59, $month, $days, $year );
		$days_after 	= (7-Date('N', $end));
		$end   += $days_after*60*60*24;	
		
		$units = $days + $days_before + $days_after; 
		break;
	case 'year':
		$units = 12;
		$start 	= mktime(0,0,0, 1, 1, $year );
		$end 	= mktime(0,0,0, 1, 1, $year+1 )-1;		
		break;
	}
	return "BETWEEN '" . time_to_DBTime( $start ) . "' AND '" . time_to_DBTime( $end ) . "' ";	
}


function SQL_BETWEEN_Day( $year, $month, $day )
{
	$start 	= mktime(0,0,0, $month, $day, $year );
	$end	= $start + (60*60*24)-1;
	return "BETWEEN '" . time_to_DBTime( $start ) . "' AND '" . time_to_DBTime( $end ) . "' ";
}

function SQL_BETWEEN_Week( $year, $month, $day )
{
	$start 	= mktime(0,0,0, $month, $day, $year );
	$start  -= Date('N', $start)*60*60*24;
	$end	= $start + (60*60*24*7)-1;
	return "BETWEEN '" . time_to_DBTime( $start ) . "' AND '" . time_to_DBTime( $end ) . "' ";
}

function SQL_BETWEEN_Month( $year, $month, $day )
{
	$start 	= mktime(0,0,0, $month, 1, $year );
	$end	= $start + (cal_days_in_month( CAL_GREGORIAN, $month, $year )*60*60*24)-1;
	return "BETWEEN '" . time_to_DBTime( $start ) . "' AND '" . time_to_DBTime( $end ) . "' ";
}

// sucht f�r eine Kalenderaufbereitung auch die Tage, die vor oder nach dem Monat kommen,
// um die ganze Woche auszuf�llen
function SQL_BETWEEN_MonthPlus( $year, $month, $day )
{
	$start 	= mktime(0,0,0, $month, 1, $year );
	$end	= $start + (cal_days_in_month( CAL_GREGORIAN, $month, $year )*60*60*24)-1;
	
	$start  -= Date('N', $start)*60*60*24;	
	$end	+= (7 - Date('N', $start))*60*60*24;
	
	return "BETWEEN '" . time_to_DBTime( $start ) . "' AND '" . time_to_DBTime( $end ) . "' ";
}


function SQL_BETWEEN_Year( $year )
{
	$start 	= mktime(0,0,0, 1, 1, $year );
	$end	= $start + (60*60*24*31)-1;
	return "BETWEEN '" . time_to_DBTime( $start ) . "' AND '" . time_to_DBTime( $end ) . "' ";
}


?>