<?php 
/**
 * @package		NosCalendar
 * @version		1.0.0
 * @copyright	Copyright (C) 2012 Horst Noreick, Inc. All rights reserved.
 * @license		GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

 
// This Line is required to pass the JEDChecker in Joomla
defined('_JEXEC') or die('Restricted access');
 
 
defined('NOS_LIBRARY') or die;

class NosCache
{
	static function MoveElapsedL1FilesToL2( $L1_cachedir, $L2_cachedir, $seconds_to_keep_in_L1 )
	{
		$cmp_time = time() - $seconds_to_keep_in_L1;		
		$cachehandler = opendir( $L1_cachedir );
		while ($file = readdir( $cachehandler ))
		{
			if ( $file == '.' || $file == '..' )
				continue;

			$L1_fullpath =  $L1_cachedir . "/". $file;
			$L2_fullpath =  $L2_cachedir . "/". $file;	
			if ( @filemtime( $L1_fullpath ) < $cmp_time )
			{
				// eine Datei, die aus im Level1 Cache abgelaufen ist kommt in den Level2 Cache
				if ( is_file( $L2_fullpath ))
					@unlink( $L2_fullpath );
				@rename( $L1_fullpath, $L2_fullpath );
			}
		}
		closedir( $cachehandler );
	}
	
	static function DeleteElapsedFiles( $cachedir, $seconds_to_keep_in_cache )
	{
		$cmp_time = time() - $seconds_to_keep_in_cache;
		$cachehandler = opendir( $cachedir );		
		while ($file = readdir( $cachehandler ))
		{
			if ( $file == '.' || $file == '..' )
				continue;
			$fullpath =  $cachedir . "/". $file;				
			if ( @filemtime( $fullpath ) < $cmp_time )
			{
				if ( is_file( $fullpath ))
					@unlink( $fullpath );
			}
		}
		closedir( $cachehandler );
	}
	
	static function Backup( $cachedir, $filename, $data )
	{
		$cachefile = $cachedir.'/'. $filename;
		file_put_contents( $cachefile, $data );	
	}
		
	static function Restore( $cachedir, $filename, &$file )
	{
		$retcode = NOS_NO_DATA_FOUND;
		$cachefile = $cachedir.'/'. $filename;
		if ( is_file( $cachefile ))
		{	 
			$file = file_get_contents( $cachefile );
			$retcode = NOS_SUCCESS;
		}
		return $retcode;
	}
}
