<?php 
/**
 * @package		NosCalendar
 * @version		1.0.0
 * @copyright	Copyright (C) 2012 Horst Noreick, Inc. All rights reserved.
 * @license		GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

// This Line is required to pass the JEDChecker in Joomla
defined('_JEXEC') or die('Restricted access');
 
 
defined('NOS_LIBRARY') or die;


class NosCalendar
{
	function __construct()
	{
		date_default_timezone_set('Europe/Berlin');	
		require_once NOSPATH_BASE.'/NosTime.php';		
	}

	static function GetInstance()
	{
		static $instance = null;
		if ( !is_object($instance))
		{
			if ( defined('_JEXEC'))
				$instance = new NosCalendar();// Joomla
			else if ( defined('NOS_CMS'))
			{
				require_once dirname(__FILE__) . '/NosCalendar_NosCMS.php';
				$instance = new NosCalendar_NosCMS();// Joomla
			}
		}
		return $instance;
	}	

	
	function Route( $uri )
	{
		return Nos::Route( $uri );
	}
	
	function AppendGeoSelectionFields( &$params, $radiusparams = true )
	{
		switch ( $this->GetParam( 'geoselect' ) )
		{
		case 'zip':
			$params['zip'] 			= $this->GetParam( 'zip' );
			break;
		case 'city':
			$params['city'] 		= $this->GetParam( 'city','string' );		
			break;		
		default: // radius
			if ( $radiusparams  )
			{
				$params['irad']	= $this->GetParam( 'irad' );
				$params['orad']	= $this->GetParam( 'orad' );
			}
							
			$center_lon 	= $this->GetParam( 'clon' );
			$center_lat 	= $this->GetParam( 'clat' );
			$center_city 	= $this->GetParam( 'ccty', 'string' );	

			
			$center_zip 	= $this->GetParam( 'czip' );
			
			if ( $center_lon && $center_lat )
			{
				$params['clon'] 	= $center_lon;
				$params['clat'] 	= $center_lat;					
			}
			else if ( $center_city )
			{
				$params['ccty'] 	= $center_city;
			}
			else if ( $center_zip )
			{
				$params['czip'] 	= $center_zip;
			}
			else
			{
			 	JFactory::getApplication()->enqueueMessage( Nos::GetString('Umkreissuche: Geocoordinaten oder PLZ muss angegeben werden') );
			}
			
				
		}
	}
	
	function CheckUserParam( $key, $value = '', $raw = false )
	{
		switch ( $key )
		{
		case 'ccty':
			if ( $value )
				$_SESSION['nos_ccty'] = $value;
			else
			{
				if ( isset($_SESSION['nos_ccty']))
					$value = $_SESSION['nos_ccty']; 
			}
			break;
		case 'clat':
			if ( $value )
			{
				if ( isset($_SESSION['nos_clat']) && $_SESSION['nos_clat'] != $value )
					$_SESSION['nos_my_location'] = '';
				$_SESSION['nos_clat'] = $value;				
			}
			else
			{
				$ccty = (string)$this->GetParam( 'ccty', 'string' );
				if ( ($ccty == 'mypos' || $raw ) && isset($_SESSION['nos_clat']) )
					$value = $_SESSION['nos_clat']; 
			}
			break;
		case 'clon':			
			if ( $value )
			{
				if ( isset($_SESSION['nos_clon']) && $_SESSION['nos_clon'] != $value )
					$_SESSION['nos_my_location'] = '';
				$_SESSION['nos_clon'] = $value;				
			}
			else
			{
				$ccty = (string)$this->GetParam( 'ccty', 'string' );
				if ( ($ccty == 'mypos' || $raw ) && isset($_SESSION['nos_clon']) )
					$value = $_SESSION['nos_clon']; 
			}
			break;
		case 'my_location':
			$value = (isset($_SESSION['nos_my_location']))? $_SESSION['nos_my_location'] : '';
			if ( !$value )
			{
				$lat = (isset($_SESSION['nos_clat']))? $_SESSION['nos_clat'] : 0;				
				$lon = (isset($_SESSION['nos_clon']))? $_SESSION['nos_clon'] : 0;
				if ( $lat && $lon )
				{
					$location = null;
					if ( $this->DetectLocation( $lat, $lon, $location ) == NOS_SUCCESS )
						$value = $location['city'];
				}
			}			 
			if ( !$value )
				$value = 'Mein Standort';
								
			break;
			
		}
		return $value;
	}
	
	/**
	 * JOOMLA
	 * 
	 */
	function GetParam( $key, $type = 'cmd', $allow_url_param = true, $default = ''   )
	{
		$value = '';
		if ( $allow_url_param )
		{
			if ( $type == 'cmdlist' )
			{			
				$value 	= (string)JRequest::getVar( $key, null, 'default', 'string' );
				$value 	= preg_replace('/[^A-Z0-9_\.+-,]/i', '', $value );
			}
			else 
			{
				$value 	= (string)JRequest::getVar( $key, null, 'default', $type );				
			}
		}
		
		$value = $this->CheckUserParam( $key, $value );
		
		if ( $value == null || $value == '' )
		{
    		$config = JFactory::getApplication()->getParams('com_noscalendar');
			$value = $config->get( $key, $default );
		}

		if ( ($value == null || $value == '') && $default  )
			$value = $default;
		
		return $value;
	}
	
	// Gibt die systemparameter als array oder URL-String zurueck
	//
	//
	function GetSysParams( $for_url = false )
	{
		static $sysparams = null;
		if ( !$sysparams )
		{
			$sysparams = array(
				'catgroups'	=> $this->GetParam('catgroups','cmdlist',true,'event'),				
				'country' 	=> $this->GetParam('country'),			
			);
			
			$this->AppendGeoSelectionFields( $sysparams, false );
			
			if ( $this->GetParam( 'selection' ) == 'scene' )
				$sysparams['scene'] = $this->GetParam('scene'); 						
			
		}
		if ( $for_url == false )
			return $sysparams;
		
		$sysparam_string = '';
		foreach ( $sysparams as $k => $v )
		{
			if ( $v ) 
				$sysparam_string .= '&' . $k . '=' . rawurlencode( $v );
				
		}
		return $sysparam_string;
	}
	
	/**
	 * JOOMLA
	 * 
	 */
	function GetTime()
	{
		static $time = 0;
		if ( !$time )
		{
			$time = time();
			$month 	= JRequest::getCmd( 'month', date( 'n', $time ) );
			$year 	= JRequest::getCmd( 'year', date( 'Y', $time ) );
			$day 	= JRequest::getCmd( 'day', date( 'j', $time ) );
 			$time = mktime(0,0,0,$month, $day, $year);
		}
		return $time;	
	}
	
	function GetDateURLParams( $mod = '', $year = 0, $month = 0, $day = 0 )
	{
		switch ( $mod )
		{
		case 'today':		
			$a = getdate( time() );
			$year 	= $a['year'];
			$month 	= $a['mon'];
			$day 	= $a['mday'];
			break;
		case 'day':		
			break;
			
		default:
			$this->GetDate( $year, $month, $day, $mod );
		}
		return "&year=$year&month=$month&day=$day";
	}
	
	function GetDate(&$year, &$month, &$day, $mod = '')
	{
		$time = $this->GetTime();
		switch ( $mod )
		{
		case 'prev_week':
			$time -= 60*60*24*7;
			break;
		case 'next_week':
			$time += 60*60*24*7;
			break;
		case 'prev_day':
			$time -= 60*60*24;
			break;
		case 'next_day':
			$time += 60*60*24;
			break;							
		}
		
		$date = getdate( $time );
		$year = $date['year'];
		$month = $date['mon'];
		$day = $date['mday'];
		
		switch ( $mod )
		{
		case 'prev_month':
			if ( $month == 1 )
			{
				$month = 12;
				$year--;
			}
			else
				$month--;
			$max_days = cal_days_in_month( CAL_GREGORIAN, $month, $year );
			if ( $day > $max_days )
				$day = $max_days;
			break;
		case 'next_month':
			if ( $month == 12 )
			{
				$month = 1;
				$year++;
			}
			else
				$month++;
			$max_days = cal_days_in_month( CAL_GREGORIAN, $month, $year );
			if ( $day > $max_days )
				$day = $max_days;
			break;
		}
	}
	
	/**
	 * JOOLA
	 * 
	 */
	function LoadTemplate( $view, $name, $tpl )
	{
		$path = $view->_path['template'][1]; // Backup
		$view->_path['template'][1] = str_replace($view->_name, $name, $this->_path['template'][1]);

		$htm = $view->loadTemplate( ( strlen($tpl)? $tpl : null) );
	
		$view->_path['template'][1] = $path; //Restore
		return $htm;
	}
	

	function PeriodButtonParams( $period, $disable = '' )
	{
	
		$day; $month; $year;
		$this->GetDate( $year, $month, $day, 'prev_month' );

		$sysparams = $this->GetSysParams( true );
		
		$tmpl = (string)JRequest::getCmd('tmpl');				
		if ( $tmpl )
			$sysparams .= '&tmpl=' . $tmpl;

			
		$arr = array();

		if ( strpos( $disable, 'no-highlight' ) === false )
		{
		$arr['highlight'] = array
					(
						'url' => JRoute::_('index.php?option=com_noscalendar&view=calendar&page=highlight' . $sysparams ),				
						'prompt'=>Nos::GetString('TID_HIGHLIGHTS'),
						'icon'=>'highlight',
						'current' => (($period == 'highlight')? true : false ),
						'tip'=> Nos::GetString('TID_HIGHLIGHTS_ANZEIGEN')				
					);
		}

		if ( strpos( $disable, 'no-month' ) === false )
		{
			$arr['month'] = array
					(
						'url' => JRoute::_('index.php?option=com_noscalendar&view=calendar&page=month' . $this->GetDateURLParams('') . $sysparams ),
						'prompt'=> Nos::GetString('TID_MONAT'),
						'current' => (($period == 'month')? true : false ),
						'tip'=> Nos::GetString('TID_MONATSKALENDER_ANZEIGEN')				
					);
		}

		if ( strpos( $disable, 'no-week' ) === false )
		{
			$arr['week'] = array
					(
						'url' => JRoute::_('index.php?option=com_noscalendar&view=calendar&page=week' . $this->GetDateURLParams('') . $sysparams ),
						'prompt'=> Nos::GetString('TID_WOCHE'),
						'current' => (($period == 'week')? true : false ),
						'tip'=>Nos::GetString('TID_WOCHENKALENDER_ANZEIGEN')				 
					);
		}

		if ( strpos( $disable, 'no-daypage' ) === false )
		{
			$arr['day'] = array
					(
						'url' => JRoute::_('index.php?option=com_noscalendar&view=calendar&page=day' . $this->GetDateURLParams(''). $sysparams ),
						'prompt'=> Nos::GetString('TID_TAG'),
						'current' => (($period == 'day')? true : false ),
						'tip'=>Nos::GetString('TID_TAGESKALENDER_ANZEIGEN') 				
					);
		}
					
		return $arr;
	}
	
	function Headline( $period, &$event = null )
	{
		$info = '';
		switch ( $period )
		{
		case 'coming':		
		case 'daylist':
			$info = Nos::GetString('TID_AKTUELLE_TERMINE');   
			break;
			
		case 'highlight':
			$info = Nos::GetString('TID_VERANSTALTUNGSTIPPS');   
			break;
			
		case 'month':
			$date = getdate( $this->GetTime());		
			$info = Nos::GetString($date['month']) . ' ' . $date['year'];   
			break;
			
		case 'week':
			$start = 0;
			$time = $this->GetTime();
			SQL_BETWEEN( $period, $time, $start );
		 	$date = getdate($start);
			$end = getdate( $start + (60*60*24 *6.5) );

			if ( $date['mon'] == $end['mon'] )			
				$info = $date['mday'] . '. &ndash; ' . $end['mday'] . '. ' . Nos::GetString($date['month']) . ' ' . $end['year'];
			else
				$info = $date['mday'] . '. ' . substr(Nos::GetString($date['month']),0,3) . '. &ndash; ' . $end['mday'] . '. ' . substr(Nos::GetString($end['month']),0,3) . '. ' . $end['year'];
			break;
		
		case 'day':
			$date = getdate( $this->GetTime());
			$info = $date['mday'] . '. ' . Nos::GetString($date['month']) . ' ' . $date['year'];
			break;
			
		case 'event':
			$date = getdate( DBTime_to_time( $event['start'] ) );
			$minutes = $date['minutes'];
			if ( !$minutes )
				$minutes = '00';
			else if ( $minutes < 10 )
				$minutes = '0' . $minutes; 
				
			$month_name = Nos::GetString($date['month']);
			if ( mb_strlen( $month_name ) > 5 )
				$month_name = mb_substr( $month_name, 0, 3 ) . '.';				
				
			$info = Nos::GetString($date['weekday']) . ', ' . $date['mday'] . '. ' . $month_name . ' ' . $date['year'];			
			break;
		}
		return $info;
	}

	function ButtonTipToolScript()
	{
		return 	"window.addEvent('domready', function(){ var JTooltips = new Tips($$('.uiButtonTip'),". 
				"{".
				"maxTitleChars: 50,". 
				"fixed: false,".
				"className: 'uiButtonTip',".
				"offsets: {'x': -20, 'y': 23}".
				"}); });";	
	}
	
	function NavigationBar($periodScrollButtonParams, $headline, $periodButtonParams )
	{
		$htm = '<!-- NAVIGATIONBAR -->';
		$htm .= '<table class="nav" cellspacing="0" cellpadding="0">';
		$htm .= '<tr>';
		$htm .= '<td class="modify_view">';
		$htm .= $this->PeriodScrollBar( $periodScrollButtonParams );
		$htm .= '</td>';
		$htm .= '<td class="headline">';
		$htm .= $headline;		
		$htm .= '</td>';
		$htm .= '<td class="select_view">';
		$htm .= $this->PeriodBar( $periodButtonParams );
		$htm .= '</td>';
		$htm .= '</tr>';
		$htm .= '</table>';
		return $htm;
	}	
	
	function PeriodScrollBar( $params )
	{
		$htm = '';
		foreach ( $params as $btn )	
		{	
			$url = isset($btn['url'])? $btn['url'] : '#';
			$htm .= '<a class="uiButton '. $btn['class'] . '" href="' . $url . '"><span class="uiButtonText uiButtonTip" title="'.$btn['tip'].'">' . $btn['prompt'] . '</span></a>';			
		}	
		$htm .= '';
		return $htm;
	}
	
	function PeriodBar( $params )
	{
		$htm = '';
		foreach ( $params as $btn )
		{
			$prompt = $btn['prompt'];
			$a_class = ( (isset($btn['current']) && $btn['current'])? ' current' : '' );
			if ( isset($btn['icon']) )
			{
				$prompt = ' &nbsp; ';
				$a_class .= ' highlight';
			}
 
			$htm .= '<a class="uiButton' . $a_class . '" href="' . $btn['url'] . '"><span class="uiButtonText uiButtonTip" title="'.$btn['tip'].'">';
			$htm .= $prompt;
			$htm .= '</span></a>';
		}
		$htm .= '';
		return $htm;
	}
	
	
	function PeriodScrollButtonParams( $period, $event = null )
	{
		$day; $month; $year;
		
		$today_button_action = $this->GetParam('today_button_action');
		
		$this->GetDate( $year, $month, $day, 'prev_month' );
		
		$sysparams = $this->GetSysParams( true );
		
		$tmpl = (string)JRequest::getCmd('tmpl');				
		if ( $tmpl )
			$sysparams .= '&tmpl=' . $tmpl;
		
		$arr = array();
				
		switch ( $period )
		{
		case 'event':
			$previous 	= (isset($event['previous']))? $event['previous'] : null;
			
			$arr['prev'] = array( 'prompt'=> '&nbsp;', 'class'=>'prev', 'tip'=> Nos::GetString('TID_VORHERIGE_WIEDERHOLUNG_ANZEIGEN') );
			if ( $previous && isset($previous['eventnr']))
				$arr['prev']['url'] = JRoute::_('index.php?option=com_noscalendar&view=event&eventid='. $previous['eventid'] . '&eventnr='. $previous['eventnr'] );
	
			break;
		case 'month':
			$arr['prev'] = array
					(
						'url' => JRoute::_('index.php?option=com_noscalendar&view=calendar&page=month' . $this->GetDateURLParams('prev_month') . $sysparams ),
						'prompt'=>'&nbsp;',
						'class'=>'prev',
						'tip'=>Nos::GetString('TID_VORHERIGER_MONAT')
					);
			if ( $today_button_action == 'current')
			{
				$arr['today'] = array
						(
							'url' => JRoute::_('index.php?option=com_noscalendar&view=calendar&page=month' . $this->GetDateURLParams('today') . $sysparams ),
							'prompt'=> Nos::GetString('TID_HEUTE'),
							'class'=>'today',
							'tip'=>Nos::GetString('TID_AKTUELLEN_MONAT_ANZEIGEN')					
						);
			}
			break;
		case 'daylist':
		case 'week':
			$arr['prev'] = array
					(
						'url' => JRoute::_('index.php?option=com_noscalendar&view=calendar&page=week' . $this->GetDateURLParams('prev_week') . $sysparams ),
						'prompt'=>'&nbsp;',
						'class'=>'prev',
						'tip'=> Nos::GetString('TID_VORHERIGE_WOCHE')					
					);
			if ( $today_button_action == 'current')
			{
				$arr['today'] = array
						(
							'url' => JRoute::_('index.php?option=com_noscalendar&view=calendar&page=week' . $this->GetDateURLParams('today') . $sysparams ),
							'prompt'=> Nos::GetString('TID_HEUTE'),
							'class'=>'today',
							'tip'=> Nos::GetString('TID_ALLE_EVENTS_DIESER_WOCHE_ANZEIGEN')					
						);
			}
			break;
		case 'day':
			$arr['prev'] = array
					(
						'url' => JRoute::_('index.php?option=com_noscalendar&view=calendar&page=day' . $this->GetDateURLParams('prev_day') . $sysparams ),
						'prompt'=>'&nbsp;',
						'class'=>'prev',
						'tip'=>Nos::GetString('TID_ALLE_EVENTS_VON_GESTERN_ANZEIGEN')															
					);
			if ( $today_button_action == 'current')
			{
				$arr['today'] = array
						(
							'url' => JRoute::_('index.php?option=com_noscalendar&view=calendar&page=day' . $this->GetDateURLParams('today') . $sysparams ),
							'prompt'=> Nos::GetString('TID_HEUTE'),
							'class'=>'today',
							'tip'=> Nos::GetString('TID_ALLE_EVENTS_VON_HEUTE_ANZEIGEN')					
						);
			}
			break;
		case 'highlight':
			$arr['prev'] = array
					(
						'url' => JRoute::_('index.php?option=com_noscalendar&view=calendar&page=highlight' . $this->GetDateURLParams('prev_week') . $sysparams ),
						'prompt'=>'&nbsp;',
						'class'=>'prev',
						'tip'=> Nos::GetString('TID_VORHERIGE_WOCHE')					
					);
			break;

		case 'coming':
			$limitstart_param = '';	
			$limitstart = JRequest::getInt('limitstart');
			$limit 		= NosCalendar::GetInstance()->GetParam( 'daylist_limit');
			
			if ( $limitstart - $limit >= 0 )
				$limitstart_param = '&limitstart=' . ($limitstart-$limit);

			$arr['prev'] = array
					(
						'url' => JRoute::_('index.php?option=com_noscalendar&view=calendar&page=coming'
										. $limitstart_param 
//										. $this->GetDateURLParams('prev_coming') 
										. $sysparams ),
						'prompt'=>'&nbsp;',
						'class'=>'prev',
						'tip'=> Nos::GetString('TID_VORHERIGE_SEITE')					
					);
			break;
			
		}

		switch ( $today_button_action )
		{
		case 'daylist':
			$arr['today'] = array
				(
					'url' => JRoute::_('index.php?option=com_noscalendar&view=calendar&page=daylist' . $this->GetDateURLParams('today') . $sysparams ),
					'prompt'=> Nos::GetString('TID_HEUTE'),
					'class'=>'today',
					'tip'=> Nos::GetString('TID_ALLE_KOMMENDEN_EVENTS_AB_HEUTE_ANZEIGEN')					
				);
			break;
		case 'coming':			
			$arr['today'] = array
				(
					'url' => JRoute::_('index.php?option=com_noscalendar&view=calendar&page=coming' . $this->GetDateURLParams('today') . $sysparams ),
					'prompt'=> Nos::GetString('TID_HEUTE'),
					'class'=>'today',
					'tip'=> Nos::GetString('TID_ALLE_KOMMENDEN_EVENTS_AB_HEUTE_ANZEIGEN')					
				);
		}
		
		
		
		
		switch ( $period )
		{
		case 'event':
			$next 		= (isset($event['next']))? $event['next'] : null;
	
			$arr['next'] = array ( 'prompt'=> '&nbsp;', 'class'=>'next', 'tip'=> Nos::GetString('TID_NAECHSTE_WIEDERHOLUNG') );
			if ( $next && isset($next[0]['eventnr']))
				$arr['next']['url'] = JRoute::_('index.php?option=com_noscalendar&view=event&eventid='. $next[0]['eventid'] . '&eventnr='. $next[0]['eventnr']);
			break;
		
		case 'month':
			$arr['next'] = array
					(
						'url' => JRoute::_('index.php?option=com_noscalendar&view=calendar&page=month' . $this->GetDateURLParams('next_month') . $sysparams ),
						'prompt'=>'&nbsp;',
						'class'=>'next',
						'tip'=>Nos::GetString('TID_ALLE_EVENTS_DES_NAECHSTEN_MONATS_ANZEIGEN')					
					);
			break;
		case 'daylist':			
		case 'week':
			$arr['next'] = array
					(
						'url' => JRoute::_('index.php?option=com_noscalendar&view=calendar&page=week' . $this->GetDateURLParams('next_week') . $sysparams ),
						'prompt'=>'&nbsp;',
						'class'=>'next',
						'tip'=>Nos::GetString('TID_ALLE_EVENTS_DER_NAECHSTEN_WOCHE_ANZEIGEN')
					);
			break;
		case 'day':
			$arr['next'] = array
					(
						'url' => JRoute::_('index.php?option=com_noscalendar&view=calendar&page=day' . $this->GetDateURLParams('next_day') . $sysparams ),
						'prompt'=>'&nbsp;',
						'class'=>'next',
						'tip'=>Nos::GetString('TID_ALLE_EVENTS_VON_MORGEN')					
					);
			break;
		case 'highlight':
			$arr['next'] = array
					(
						'url' => JRoute::_('index.php?option=com_noscalendar&view=calendar&page=highlight' . $this->GetDateURLParams('next_highlight') . $sysparams ),
						'prompt'=>'&nbsp;',
						'class'=>'next',
						'tip'=>Nos::GetString('TID_WEITERE_HIGHLIGHTS')					
					);
			break;
			
		case 'coming':
			$limit 		= NosCalendar::GetInstance()->GetParam( 'daylist_limit');		
			$limitstart_param = '&limitstart=' . (JRequest::getInt('limitstart')+$limit); 
		
			$arr['next'] = array
					(
						'url' => JRoute::_('index.php?option=com_noscalendar&view=calendar&page=coming'
											. $limitstart_param 
//											. $this->GetDateURLParams('next_coming') 
											. $sysparams ),
						'prompt'=>'&nbsp;',
						'class'=>'next',
						'tip'=>Nos::GetString('TID_NAECHSTE_SEITE')					
					);
			break;
			
		}	
					
		return $arr;
	}


	function DetectStyleSheet()
	{
		$stylesheet = '';
		
		$app	= JFactory::getApplication();
		
		// Load css-file
		$style_css_loading = $this->GetParam( 'style_css_loading' );
		
    	switch ( $style_css_loading )
    	{
    	case 'css_load_special':
			$style_css_file = $this->GetParam( 'style_css_file' );
			if ( !empty( $style_css_file ) )
			{
	    	    $css_relpath_template = 'templates/' . $app->getTemplate().'/css/'. $style_css_file;
    				    	    
	    		if ( !file_exists( JPATH_BASE . '/' . $css_relpath_template ) )
	    		{
					JFactory::getApplication()->enqueueMessage( 'Config Error: css-file "'. $style_css_file . '" not available' );
					$style_css_file = '';
	    		}
			}	
			if ( $style_css_file )
			{
    	    	$css_relpath_template = 'templates/' . $app->getTemplate().'/css/'. $style_css_file;	    		
    			$stylesheet = JURI::base() . $css_relpath_template;
    			break;
			}
			// else weiter!
    	
    	case 'css_load_auto':
    	    $css_relpath_template = 'templates/' . $app->getTemplate().'/css/noscalendar.css';
    		if ( file_exists( JPATH_BASE . '/' . $css_relpath_template ) )
    		{
    			$stylesheet = JURI::base() . $css_relpath_template;
	   		}	
    		else
    		{ 
				$stylesheet = JURI::base().'components/com_noscalendar/assets/css/noscalendar.css';
    		}				    		
    		break;
    		
    	case 'css_load_ignore':
    		break;
    		    		
    	case 'css_load_from_component':	    		
    	default:
			$stylesheet = JURI::base().'components/com_noscalendar/assets/css/noscalendar.css';
    	}
		return $stylesheet;	
	}
	
		
	function URLSEGMENT( $src )
	{
		$search 	= array('&','-','  ','ä', 'Ä', 'ö', 'Ö', 'ü', 'Ü', 'ß', 'á','Á','é','É', ' ','--' );
		$replace 	= array('',' ', ' ', 'ae','ae','oe','oe','ue','ue','sz','a','a','e','e', '-','-' );		
		$src = str_replace( $search, $replace, $src );
		
		$src = strtolower( $src );
		$src = trim( $src, '-' );		
		
		return (string)preg_replace('/[^A-Z0-9-]/i', '', (string)$src );		
	}
	
	function Itemid()
	{
		static $itemid = -1;
		if ( $itemid == -1 )
		{
//			$items 	= JSite::getMenu()->getItems('component', 'com_noscalendar');
			$app	= JFactory::getApplication();
			$menus	= $app->getMenu('site');
			$items 	= $menus->getItems('component', 'com_noscalendar');
			
			$itemid = (is_array($items) && isset($items[0]))? $items[0]->id : 0;
		}
		return $itemid;
	}

	/*
	 * 
	 * @param  $event ist FastBroadcastCalendarEvent
	 */
	function EventURL( FastBroadcastCalendarEvent $event, $itemid = '', $link_to='' )
	{
		$event_id = $event->Id();
		$event_nr = $event->Nr();		
	
		$tmpl = (string)JRequest::getCmd('tmpl');				
		if ( $tmpl )
			$tmpl .= '&tmpl=' . $tmpl;

		$url_summary = $this->URLSEGMENT( $event->Summary() );
					
		$sef = JFactory::getConfig()->get('sef', 1);
		$summary = ($sef)? '&summary=' . $url_summary : '';			

//		$fragment = $event['eventid'].'-'.$event['eventnr'].'-'.$url_summary;
		$fragment = $event_id .'_'.$event_nr;				
		
		if ( !$itemid )
			$itemid = $this->Itemid();
				
		if ( $itemid )
			$itemid = '&Itemid=' . $itemid;		

		
		
		$url = '';
		switch ( $link_to )
		{
		case 'view_eventlist':
			$catgroup 	= $event->Catgroup();
			$scene 		= $event->Scene();
			$ccty		= $this->GetParam( 'ccty', 'string' );		
			if ( $sef )
				$url = 'index.php?option=com_noscalendar&view=eventlist&scene='.$scene.'&catgroups='.$catgroup.'&ccty='.$ccty.$itemid.'&summary='.$summary.'#'.$fragment;
			else										
				$url = 'index.php?option=com_noscalendar&view=eventlist&scene='.$scene.'&catgroups='.$catgroup.'&ccty='.$ccty.$itemid.'#'.$fragment;
					
			break;	
/*			
		case 'view_calendar':	
		case 'list':
			$catgroup 	= $event->Catgroup();
			$scene 		= $event->Scene();
			$ccty		= $this->GetParam( 'ccty', 'string' );		
			$page		= 'coming'; 
			$url = 'index.php?option=com_noscalendar&view=calendar&page='.$page.'&catgroups='.$catgroup.'&ccty='.$ccty.$itemid.'#'.$fragment;		
			break;
*/
		case 'view_calendar':	
		case 'list':
			// catgroups wurde deaktiviert, weil gruppen in Kalendern zusammengefasst 
			// werden können. Pro Event ist aber nur eine Gruppe zugewiesen, sodass
			// hier eine falsche Liste angezeigt würde!
//			$catgroup 	= $event->Catgroup();
			$scene 		= $event->Scene();
			$ccty		= $this->GetParam( 'ccty', 'string' );		
			$page		= 'coming'; 
			$url = 'index.php?option=com_noscalendar&view=calendar&page='.$page.'&ccty='.$ccty.$itemid.'#'.$fragment;		
			break;
			
		default:
//			$url = 'index.php?option=com_noscalendar&view=event&eventid=' . $event_id . '&eventnr=' . $event_nr . $summary.$itemid.$tmpl;
			$url = 'index.php?option=com_noscalendar&view=calendar&page=event&eventid=' . $event_id . '&eventnr=' . $event_nr . $summary.$itemid.$tmpl;			
		}			
			
		return Nos::Route( $url );	
	}
	
/*	
	function EventURL( $event, $itemid = '', $link_to='' )
	{
	
		$tmpl = (string)JRequest::getCmd('tmpl');				
		if ( $tmpl )
			$tmpl .= '&tmpl=' . $tmpl;

		$url_summary = $this->URLSEGMENT( $event['summary'] );
					
		$sef = JFactory::getConfig()->get('sef', 1);
		$summary = ($sef)? '&summary=' . $url_summary : '';			

//		$fragment = $event['eventid'].'-'.$event['eventnr'].'-'.$url_summary;
		$fragment = $event['eventid'].'_'.$event['eventnr'];				
		
		if ( !$itemid )
			$itemid = $this->Itemid();
				
		if ( $itemid )
			$itemid = '&Itemid=' . $itemid;		

		
		
		$url = '';
		switch ( $link_to )
		{
		case 'view_eventlist':
			$catgroup 	= $event['catgroup'];
			$scene 		= $event['scene'];
			$ccty		= $this->GetParam( 'ccty', 'string' );		
			if ( $sef )
				$url = 'index.php?option=com_noscalendar&view=eventlist&scene='.$scene.'&catgroups='.$catgroup.'&ccty='.$ccty.$itemid.'&summary='.$summary.'#'.$fragment;
			else										
				$url = 'index.php?option=com_noscalendar&view=eventlist&scene='.$scene.'&catgroups='.$catgroup.'&ccty='.$ccty.$itemid.'#'.$fragment;
					
			break;	
		case 'view_calendar':	
		case 'list':
			$catgroup 	= $event['catgroup'];
			$scene 		= $event['scene'];
			$ccty		= $this->GetParam( 'ccty', 'string' );		
			$page		= 'coming'; 
			$url = 'index.php?option=com_noscalendar&view=calendar&page='.$page.'&catgroups='.$catgroup.'&ccty='.$ccty.$itemid.'#'.$fragment;		
			break;
		default:
			$url = 'index.php?option=com_noscalendar&view=event&eventid=' . $event['eventid'] . '&eventnr=' . $event['eventnr'] . $summary.$itemid.$tmpl;
		}			
			
		return Nos::Route( $url );	
	}
*/
	
/*	
	function ImageURL( $id, $file, $group, $width = 0, $height = 0  )
	{
    	$config = JFactory::getApplication()->getParams('com_noscalendar');		

		$host = strtolower( $config->get( 'host' ) );

		$fileparams = '';
		switch ( $group )
		{
		case 'event':	
			$fileparams = "&amp;eventid=$id&amp;file=$file";
			break;
		case 'person':	
			$fileparams = "&amp;persid=$id&amp;file=$file";
			break;
		}
		if ( $width )
			$fileparams .= "&amp;width=$width";
		if ( $height )
			$fileparams .= "&amp;height=$height";
			
		$accessparams = "/image.php?rpc_method=V001_Calendar_GetImage";
		return "http://". $host . $accessparams . $fileparams;	
	}
*/	
/*
	function DownloadURL( $id, $file, $group  )
	{
    	$config = JFactory::getApplication()->getParams('com_noscalendar');		

		$host = strtolower( $config->get( 'host' ) );

		$fileparams = '';
		switch ( $group )
		{
		case 'event':	
			$fileparams = "&amp;eventid=$id&amp;file=$file";
			break;
		case 'person':	
			$fileparams = "&amp;persid=$id&amp;file=$file";
			break;
		}
			
		$accessparams = "/rpc.php?rpc_method=V001_Calendar_GetFile";
		return "http://". $host . $accessparams . $fileparams;	
	}
*/	
	
	function PartnerLogoURL( $id )
	{
    	$config = JFactory::getApplication()->getParams('com_noscalendar');

		$host = strtolower( $config->get( 'host' ) );
		$fileparams = "&amp;persid=$id";
		$accessparams = "/image.php?rpc_method=V001_Calendar_GetPartnerLogo";
		return "http://". $host . $accessparams . $fileparams;	
	
	}
	
	function IsPool( $str )
	{
		$pools = array( 'dance', 'spirit' );
		return in_array( $str, $pools );
	}
		
	function IsScene( $str )
	{
		$scenes = array('salsa', 'tango', 'swing','zouk','standardlatin');
		return in_array( $str, $scenes );		
	}

/*	
	function IsCatgroup( $str )
	{
		$categories = array('event','events', 'workshop','workshops','lesson','lessons','kurs', 'kurse'  );
		return in_array( $str, $categories );		
	}
*/

	function IsCatgroup( $str, &$catgroup = null )
	{
		$catgroups = array(	'event'=>'event','events'=>'event',
						 	'workshop'=>'workshop','workshops'=>'workshop',
						 	'lesson'=>'lesson','lessons'=>'lesson','kurs'=>'lesson', 'kurse'=>'lesson'  );
		if (isset($catgroups[$str]))
		{
			if ( is_string($catgroup) )
				$catgroup = $catgroups[$str]; 
			return true;
		}
		return false;
	}
	
	
	function IsJoin( $str, &$join )
	{
		$joins = array('in'=>'in', 'at'=>'at', 'bei'=>'at');
		$join = ( isset($joins[$str]))? $joins[$str] : '';
		return strlen($join); 
	}	
	
	function GetScenes( $pool, &$scenes )
	{
		$retcode = NOS_SUCCESS;
		switch ( $pool )
		{
		case 'dance':
			$scenes = array('salsa', 'tango', 'swing','zouk','standardlatin');
			break;
		case 'spirit':
			$scenes = array('yoga', 'meditation');
			break;
		default:
			$retcode = NOS_ERROR;
		}
		return $retcode;
	}
	
	function GetConfig( $params, &$result )
	{
		$params['rpc_method'] = 'V001_Application_GetConfig';		
		return self::ServerRequest( $params, $result );
	}	
	
	function GetEventList( $params, &$eventlist, &$info = null )
	{
		$params['rpc_method'] = 'V001_Calendar_GetEventList';		
		if ( ($retcode = self::ServerRequest( $params, $result )) == NOS_SUCCESS )
		{
			$eventlist = $result['eventlist'];
			$info = $result['info'];
		}
		return $retcode;
	}	

 	function DetectLocation( $lat, $lon, &$result )
	{
		$params['rpc_method'] = 'V001_Geo_DetectLocation';
		$params['lat'] = $lat;
		$params['lon'] = $lon;		
		if ( ($retcode = self::ServerRequest( $params, $result )) == NOS_SUCCESS )
			$result = $result['location'];
		return $retcode;
	}	
	
	function GetEvent( $params, &$result )
	{
		$params['rpc_method'] = 'V001_Calendar_GetEvent';		
		if ( ($retcode = $this->ServerRequest( $params, $result )) == NOS_SUCCESS )
			$result = $result['event'];
		return $retcode;
	}	

	function GetStatistik( $params, &$result )
	{
		$params['rpc_method'] = 'V001_Calendar_GetStatistik';		
		if ( ($retcode = self::ServerRequest( $params, $result )) == NOS_SUCCESS )
			$result = $result['statistik'];
		return $retcode;
	}	
	
	
	function GetPartnerList( $params, &$result )
	{
		$params['rpc_method'] = 'V001_Calendar_GetPartnerList';
		if ( ($retcode = $this->ServerRequest( $params, $result )) == NOS_SUCCESS )
			$result = $result['partnerlist'];
		return $retcode;
	}	

	/**
	 * 
	 * 
	 * @param 	array  	$params 	The params for the request.
	 * @param	mixed	$result		The answer from the server.
	 * 
	 * @return	int					The retcode	
	 */
	public static function ServerRequest( array $params, &$result )	
	{
		if ( defined( 'NOS_FACEBOOK' ) )
			return NosCalendar::LocalRequest( $params, $result );
//		else
		return NosCalendar::RemoteRequest( $params, $result );
	}

	// LocalRequest
	public static function LocalRequest( $params, &$result )
	{
		$retcode = NOS_ERROR;
		
		if ( !defined('NOSPATH_ROOT'))		
			define('NOSPATH_ROOT', JPATH_BASE );
	
		if ( !defined('NOSPATH_COMPONENT'))
			define('NOSPATH_COMPONENT', NOSPATH_ROOT.'/components/com_nosform' );
		if ( !defined('NOSPATH_BASE'))		
			define('NOSPATH_BASE', NOSPATH_COMPONENT .'/helpers');
		
		require_once NOSPATH_COMPONENT.'/helpers/Nos.php';
		if ( !defined('NOS_PROFILER'))
			define('NOS_PROFILER', false );
		
		require_once NOSPATH_BASE.'/NosRPCMethod.php';
		$result = array();
		$retcode = NosRPCMethod::Exec( $params['rpc_method'], $params, $result );
		
		return $retcode;
	}
	
	public static function RemoteRequest( $params, &$result )
	{
		require_once dirname(__FILE__).'/NosCache.php';
		
		$config = JComponentHelper::getParams( 'com_noscalendar' );
    	
		$host = strtolower( $config->get( 'host','fastbroadcast.de' ) );
		
		$method = "GET";
		$uri = "/rpc.php";
		
		$params['rpc_accept'] = 'json';
		$params['appid'] = $config->get( 'appid' );		
		
		$query = array();
		foreach ($params as $k => $v )
			$query[] = $k . '='. rawurlencode( $v );
		
		$query = implode( '&', $query );

		// create request
		$request = "http://".$host.$uri."?".$query;

		$cachedir = NOSPATH_CALENDAR.'/cache';

//		$seconds_to_keep_in_L1 = 900;
		$seconds_to_keep_in_L1 	= 10;
		$hours_to_keep_in_L2 	= 48;				
		
		// Level 1 Cache
		$L1_cachedir = $cachedir . '/L1';
		$L2_cachedir = $cachedir . '/L2';		

		// Level 1 Cache aktualisieren
		NosCache::MoveElapsedL1FilesToL2( $L1_cachedir, $L2_cachedir, $seconds_to_keep_in_L1 );
		// Level 2 Cache aktualisieren
		NosCache::DeleteElapsedFiles( $L2_cachedir, 60 * 60 * $hours_to_keep_in_L2 );

		$restored_from_L1 = false;
		if ( NosCache::Restore( $L1_cachedir, md5($request), $jresponse ) == NOS_SUCCESS )
		{
			$restored_from_L1 = true;
		}
		else 
		{
			// do request
			if (is_callable("curl_exec"))
			{
				// curl-Request: POST
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, $request );			
				curl_setopt($ch, CURLOPT_VERBOSE, 1);
				curl_setopt($ch, CURLOPT_POST, 0);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
				$jresponse = curl_exec($ch);
				curl_close ($ch);
			}
			else 
			{
				$jresponse = @file_get_contents($request);
			}
		}	    

		$response = json_decode( $jresponse, true );
		if ( is_array( $response ) )
			$retcode = (isset( $response['retcode'] ))? $response['retcode'] : NOS_ERROR;
		else
			$retcode = NOS_ERROR;

		$use_l2_cache_on_error 	= true;
		
		// Im Fehlerfall wird versucht Daten aus dem Level 2 Cache anzubieten
		switch ( $retcode )
		{
		case NOS_NO_DATA_FOUND:		
		case NOS_SUCCESS:
			break;
		default:							
			if ( $use_l2_cache_on_error )
			{
				if ( NosCache::Restore( $L2_cachedir, md5($request), $jresponse ) == NOS_SUCCESS )
				{
					$response = json_decode( $jresponse, true );
					if ( is_array( $response ) )
						$retcode = (isset( $response['retcode'] ))? $response['retcode'] : NOS_ERROR;
					else
						$retcode = NOS_ERROR;
				}
			}
		}			
		
		switch ( $retcode )
		{
			case NOS_NO_DATA_FOUND:		
			case NOS_SUCCESS:
				$result = $response['result'];				
						
				if ( !$restored_from_L1 && $seconds_to_keep_in_L1 )
					NosCache::Backup( $L1_cachedir, md5($request), $jresponse );
					
				break;
			default:
				if ( is_array( $response ) )
					JFactory::getApplication()->enqueueMessage( 'Remote Server Error: '.$response['error'][0]['error'] . ' ' . $response['error'][0]['message'] ) ;
				else
					JFactory::getApplication()->enqueueMessage( 'Remote Server Error: '.$jresponse );				
		}
				
		return $retcode;
	}
	
}

