<?php
/**
 * @package		NosCalendar
 * @version		1.0.0
 * @copyright	Copyright (C) 2012 Horst Noreick, Inc. All rights reserved.
 * @license		GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */
 
defined('_JEXEC') or die('Restricted access');
 
defined('NOS_LIBRARY') or die;
	
class NosCalendarCityCloud
{
	var $fontsize_min			= 10;
	var $max_items 				= 20;
	var $max_tags				= 7;

	protected $path				= 'index.php';	
	protected $query			= null;
	protected $class			= 'citycloud';	
	protected $insert_my_position = true;	
	
	function __construct()
	{
	}

	static function CreateInstance()
	{
		static $instance = null;
		if ( !$instance )
		{
			if ( !defined('NOSPATH_CALENDAR') )
				define('NOSPATH_CALENDAR', JPATH_ROOT.'/components/com_noscalendar' );
			
			if ( !defined('NOS_LIBRARY') )
				require_once NOSPATH_CALENDAR.'/Nos/Nos.php';
		
			$instance = new NosCalendarCityCloud();
		}
		return $instance;
	}

	function SetPath( $path )
	{
		$this->path = $path;
	}
	function SetQuery( $query )
	{
		$this->query = $query;
	}
	
	
	function GetStatistic( &$statistic )
	{
		$calendar = NosCalendar::GetInstance();
		
		$rpcparams = array('country'=>'D');
		$rpcparams['date']		= date( "Y-m-d", $calendar->GetTime() );
		$rpcparams['period']	= 'month_plus';
		
		switch ( $calendar->GetParam( 'selection' ) )
		{
		case 'pool':
			$rpcparams['pool']		= $calendar->GetParam( 'pool' );
			break;	
		case 'scene':
			$rpcparams['scenes']	= $calendar->GetParam( 'scene' );
			break;		
		}
		return $calendar->GetStatistik( $rpcparams, $statistic );
	}

	/*
	 * @params may be array with key/value or the value for ccty
	 * 
	 */
	function URI( $params = null )
	{
		$uri = $this->path . '?';

		if ( is_array( $this->query ) )		
		{
			foreach ( $this->query as $k => $v )
				$uri .= $k . '=' . rawurlencode( $v ) . '&';
		}
		
		if ( is_array( $params ))
		{
			foreach ( $params as $k => $v )
				$uri .= $k . '=' . rawurlencode( $v ) . '&';
		}
		else if ( is_string( $params ) )
		{
			$uri .= 'ccty=' . rawurlencode($params);
		}
		
//		return JRoute::_( $uri );
		return NosCalendar::GetInstance()->Route( $uri );
	}

		
	function Render()
	{
		$statistik = null;	
		if ( $this->GetStatistic( $statistik ) != NOS_SUCCESS )
		{
//			$errlist = NosGetErrorListUTF8();
//			foreach ($errlist as $err )
//				echo $err['message'];
			return '';
		}
		
		if ( !count($statistik) )
			return '';
		// kopieren in ein sortierbares Array
		$citys = array();
		foreach ( $statistik as $row )
			$citys[$row['city']] = (int)$row['evts']; 
		
		arsort( $citys );
		// und entfernen der nicht benötigten Werte
		array_splice($citys, $this->max_items );
		
		// Ermitteln von min und max
		$evts_min = $statistik[0]['evts'];
		$evts_max = 0;
		foreach ( $citys as $k => $v )
		{
			if ( $v > $evts_max )
				$evts_max = $v;
			if ( $v < $evts_min )
				$evts_min = $v;
		}
		
		$max_tags = $this->max_tags;
		$slot_size = $evts_max / $max_tags;

		$query 		= $this->query;
		if ( !is_array( $query ) )
			 $query = array();
		
		$calendar = NosCalendar::GetInstance();		
		
		$currentcity = $calendar->GetParam('ccty', 'string');
		$text_my_location = $calendar->CheckUserParam( 'my_location', '', true );		

		$my_lon = $calendar->GetParam('clon');
		if ( !$my_lon ) 
			$my_lon = $calendar->CheckUserParam( 'clon', null, true );
		
		$my_lat = $calendar->GetParam('clat');
		if ( !$my_lat )
			$my_lat = $calendar->CheckUserParam( 'clat', null, true );
		
		$htm = '<div class="' . $this->class . '">' . "\n";

		if ( $slot_size )
		{
			$insert_my_position_done = false;
			
			foreach ( $statistik as $row )
			{
				if ( !isset( $citys[$row['city']] ) )
					continue;

				$class = 'item';
				
				if ( $this->insert_my_position && !$insert_my_position_done && $row['city'] > $text_my_location )
				{
					$size = (int)($evts_max / $slot_size);
					$fontsize = $this->fontsize_min + $size;
					
					$mypos_class = $class;
					if ( $currentcity == 'mypos' )
						$mypos_class = ' current';
					
					$mypos_refresh_url   = 'javascript:LookForGeoposition(this);';				
					$mypos_url   = '';			
					if ( $my_lon && $my_lat )
						$mypos_url = $this->URI( array( 'ccty'=> 'mypos', 'clat'=> $my_lat, 'clon'=> $my_lon ));
					else
						$mypos_url = $mypos_refresh_url;				
					
					$htm .= '<span id="cloud_mypos" class="' . $mypos_class . '" style="font-size: ' . $fontsize . 'px;"><a id="cloud_mypos_refresh" href="'. $mypos_refresh_url . '">&nbsp;</a><a id="cloud_mypos_a" href="'. $mypos_url . '">' . $text_my_location . "</a></span> \n";
					
					$insert_my_position_done = true;
				}
		
				// Die Stadt wird nicht doppelt angezeigt
				if ( $row['city'] == $text_my_location )
					continue;
				
				if ( $row['city'] == $currentcity )
					$class .= ' current';
				
				$size = (int)($row['evts'] / $slot_size);
				$fontsize = $this->fontsize_min + $size;
						
				$htm .= '<span class="' . $class . '" style="font-size: ' . $fontsize . 'px;"><a href="'. $this->URI( $row['city'] ) . '">' . $row['city'] . "</a></span> \n";
			}
		}
		
		$htm .= '</div>';

		$htm .= '<script type="text/javascript">' . "\n"
				.'<!--' . "\n"
				.'var mypos_url = "' . $this->URI()  . '"' . "\n"
				. file_get_contents( dirname(__FILE__).'/NosCityCloud.js') . "\n"
				.'//-->' . "\n"
				.'</script>';
				
		echo $htm;
	}
	

}
?>
