<?php 
/**
 * @package		NosCalendar
 * @version		1.0.0
 * @copyright	Copyright (C) 2012 Horst Noreick, Inc. All rights reserved.
 * @license		GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

// This Line is required to pass the JEDChecker in Joomla
defined('_JEXEC') or die('Restricted access');
 
 
defined( 'NOS_LIBRARY' ) or die( 'Restricted access' );

// NosCalendarMonthStub ist eine Prototypklasse
// Datenbankspezifische Funktionen m�ssen in
// abgeleiteten Klassen implementiert werden
//


require_once NOSPATH_CALENDAR_HELPERS.'/NosCalendarStub.php';

class NosCalendarDay extends NosCalendarStub 
{
	function NosCalendarDay()
	{
		$this->class 	= 'noscalendar day';
	}
	
	function Export()
	{
		$time = $this->time;
				
		$htm = '';
		$htm .= "<table style=\"width:100%\" class=\"$this->class\" cellspacing=\"0\" cellpadding=\"0\">";
		$htm .= "<tr>";
		$htm .= "<td class=\"day\">";						

		$this->offset = 0;
		if ( $this->event )
		{
			foreach ( $this->event as $event )
			{
				$htm .= $this->Event();			
				$this->offset++;				
			}
		}		
		
		$htm .= "</td>";
		$htm .= "</tr>";						
		$htm .= "</table>";			 
	
		return $htm;		
	}
	
	function Event()
	{
		$event =& $this->event[$this->offset];		
		$class = 'event '; 
		if ( $event['clientstate'] )
			$class .= ' clientevent';
		
		$eventurl 	= Nos::Route('index.php?option=com_noscalendar&view=event&eventid=' . $event['eventid'] . '&eventnr=' . $event['eventnr'] );				
				
		$htm = "<div class=\"$class\"><a href=\"$eventurl\" ><span>" . substr($event['start'], 11, 5) . " - " . $event['summary'] . " </span></a></div>";
	
		return $htm;
	}		
	
}



?>