<?php 
/**
 * @package		NosCalendar
 * @version		1.0.0
 * @copyright	Copyright (C) 2012 Horst Noreick, Inc. All rights reserved.
 * @license		GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

// This Line is required to pass the JEDChecker in Joomla
defined('_JEXEC') or die('Restricted access');
 
 
defined( 'NOS_LIBRARY' ) or die( 'Restricted access' );

// NosCalendarMonthStub ist eine Prototypklasse
// Datenbankspezifische Funktionen müssen in
// abgeleiteten Klassen implementiert werden
//


require_once NOSPATH_CALENDAR_HELPERS.'/NosCalendarStub.php';

class NosCalendarEvent extends NosCalendarStub 
{
	
	function NosCalendarEvent()
	{
		$this->class 	= 'noscalendar event';
	}
	
	function Export()
	{
		$htm = '';
		
		$htm .= $this->event['test']; 
		
		return $htm;
	}
	
/*	
	function Export( $id, $db )
	{
		$query =	"SELECT * FROM #__nos_calendar c, #__nos_calevent e".
					" WHERE c.eventid = e.eventid".
					" AND c.id = $id";
		$arr = array();
		
		$db->Exec( $query, $arr );		
		
		$htm = '';
//		$htm .= $this->Layout_1( $arr );
		


		require_once NOSPATH_BASE.'/NosVEVENT.php';				
		$vevent = new NosVEVENT();	
		$vevent->ImportString( $arr['vevent']);

//		$htm .= $this->Location( $vevent );
		
		$htm .= $this->Address( $vevent->x_nos_location );
		$htm .= '<br />';
		
		if ( $vevent->x_nos_dj )
		{
			$htm .= '<br />';
			$htm .= '<u>' . Nos::GetString('DJs') . '</u><br />'; 
			foreach ( $vevent->x_nos_dj as $dj )
				$htm .= $this->Address( $dj );
		}		
		
		if ( $vevent->description )
		{
			$htm .= $vevent->description . '<br /><br />';
		}
		
		list( $year, $month, $day, $hour, $minute, $second) = sscanf( $arr['start'], '%4d-%2d-%2d %2d:%2d:%2d');
		$htm .= Nos::GetString('TID_BEGINN') . ': ' . $hour . ':'. $minute . ' ' . Nos::GetString('TID_UHR') . '<br / >';		
		
		if ( $vevent->x_nos_entry )
		{
			$entry = $vevent->x_nos_entry;
						
			$htm .= Nos::GetString('TID_EINTRITT') . ': ';
			
			if ( isset( $entry['FREE']) && $entry['FREE'] == '1' )				
				$htm .= Nos::GetString('TID_FREI') ;
			else if ( isset( $entry['ENTRY']) && $entry['ENTRY'] > '0.0' )
				$htm .= $entry['ENTRY'] . ' ' . Nos::GetString('TID_EURO') ;
			
				
			$htm .= '<br />';				 
		}
		
		if ( $vevent->x_nos_organizer )
		{
			$htm .= '<br />';
			$htm .= '<u>' . Nos::GetString('TID_VERANSTALTER') . '</u><br />'; 
			foreach ( $vevent->x_nos_organizer as $organizer )
				$htm .= $this->Address( $organizer );		
		}		
		
		$htm .= '<br /><hr /><br />';		
		$htm .= $this->Dump($arr);
		
		return $htm;
	}
*/
	function Address( $address )
	{
		$htm = '';
		if ( $address )
		{
			$htm .= '<b>' . $address['NAME'] . '</b><br />';
			$htm .= $address['STREET'] . '<br />';
			$htm .= $address['ZIP'] . ' ' . $address['CITY'] . '<br />';			
		}
		return $htm;
	}
	
	
	function Location( $vevent )
	{
		$htm = '';
		if ( $vevent->x_nos_location )
		{
			$htm .= '<b>' . $vevent->x_nos_location['NAME'] . '</b><br />';
			$htm .= $vevent->x_nos_location['STREET'] . '<br />';
			$htm .= $vevent->x_nos_location['ZIP'] . ' ' . $vevent->x_nos_location['CITY'] . '<br />';			
		}
		return $htm;
	}
	
	function Layout_1( $arr )
	{
	?>
		<b><?php echo $arr['summary'];?></b>
		<br />
		
	<?php 	
	}
	
	function Dump($arr)
	{
		$htm = '<table>';
		foreach ( $arr as $k => $v )
		{
			switch ( $k )
			{
			case 'vevent':
				$v = str_replace("\r\n","<br/>", $v );
				break;
			}
			$htm .= "<tr><td>$k</td><td>$v</td></tr>";			
		}		
		$htm .= '</table>';
		return $htm;
	}
	
}



?>