<?php 
/**
 * @package		NosCalendar
 * @version		1.0.0
 * @copyright	Copyright (C) 2012 Horst Noreick, Inc. All rights reserved.
 * @license		GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

// This Line is required to pass the JEDChecker in Joomla
defined('_JEXEC') or die('Restricted access');
 
defined( 'NOS_LIBRARY' ) or die( 'Restricted access' );

require_once NOSPATH_CALENDAR_HELPERS.DS.'NosCalendarStubMonth.php';

/* SAMPLE:
 * 
 * $cal_month = new NosCalendarMonth;
 * $cal_month->showLineHeader = false;
 * echo $cal_month->Export( time(), $db );
 * 
 * 	
*/

class NosCalendarMonth extends NosCalendarStubMonth
{
	var $event			= 0;
	var $event_class	= 0;
	
	function DayCellEvent($day, $current)
	{
		$event =& $this->event[$this->offset];
		
		$this->event_class->SetEvent( $event );
		
		$d = getdate($day);		
		$class = 'event ' . (($this->date['mon'] == $d['mon'] )? 'event_in' : 'event_out'); 
		if ( isset($event['clientstate']) && $event['clientstate'] )
			$class .= ' clientevent';
		
		$htm = '<div class="' . $class . '">'
				.'<a href="'. NosCalendar::GetInstance()->EventURL( $this->event_class, JRequest::getInt('Itemid') ) . '" >' 
					. $this->event_class->Summary()					 
				. '</a></div>';
	
		return $htm;
	}		
	
	function DayCellEvents($day, $current)
	{
		$htm = '';
		$day_dbtime = time_to_DBTime( $day );
//		if ( count( $this->event ) )
		if ( isset( $this->event[$this->offset] ) )		
		{				
			while ( !strncmp( $day_dbtime, $this->event[$this->offset]['start'], 10 ) )
			{
				$htm .= $this->DayCellEvent($day, $current);
//				if ( $this->offset >= count( $this->event ) )
				if ( !isset( $this->event[ $this->offset + 1 ] ) )				
					break;
				$this->offset++;
			}
		}
		return $htm;
	}
	
	
} 

?>