<?php 
/**
 * @package		NosCalendar
 * @version		1.0.0
 * @copyright	Copyright (C) 2012 Horst Noreick, Inc. All rights reserved.
 * @license		GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

 
// This Line is required to pass the JEDChecker in Joomla
defined('_JEXEC') or die('Restricted access');
 
defined( 'NOS_LIBRARY' ) or die( 'Restricted access' );

require_once NOSPATH_CALENDAR_HELPERS.DS.'NosCalendarStubMonth.php';


class NosCalendarMonthWidget extends NosCalendarStubMonth
{
	var $event		= 0;
	
	function Export( $time, $db )
	{
		$this->event = $db->CreateView( 'NosViewCalendar');
		$this->event->Open( 'month_plus', $time );
		$this->event->Fetch();
		return NosCalendarStubMonth::Export( $time );
	}

	function DayCell($day)
	{
		$d = getdate($day);

		$hasEvent = false;
		$day_dbtime = time_to_DBTime( $day );		
		while ( !strncmp( $day_dbtime, $this->event->start, 10 ) )
		{
			$hasEvent = true;
			if ( $this->event->Fetch() != NOS_SUCCESS )
				break; 
		}
		
		$current = $this->IsCurrentDay($day);
		
		$class = 'day ' . date( 'D', $day ) . ' ';
		if ( $hasEvent )
			$class .= 'has_event ';
		if ( $current ) 
			$class .= 'current';
		else
			$class .= (($this->date['mon'] == $d['mon'] )? 'in' : 'out');
			 
		$htm = "<td class=\"$class\" width=\"14%\" valign=\"top\">". 
			$d['mday']. 
			'</td>';
		return $htm;
	}	
	
} 


?>