<?php 
/**
 * @package		NosCalendar
 * @version		1.0.0
 * @copyright	Copyright (C) 2012 Horst Noreick, Inc. All rights reserved.
 * @license		GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

// This Line is required to pass the JEDChecker in Joomla
defined('_JEXEC') or die('Restricted access');
 
 
defined( 'NOS_LIBRARY' ) or die( 'Restricted access' );
// NosCalendarMonthStub ist eine Prototypklasse
// Datenbankspezifische Funktionen müssen in
// abgeleiteten Klassen implementiert werden
//
// TODO: Style entfernen Zeile 27++

require_once NOSPATH_CALENDAR_HELPERS.DS.'NosCalendarStub.php';

class NosCalendarStubMonth extends NosCalendarStub 
{
	
	function __construct()
	{
		$this->class = 'view_month';
	}
	
	
	function Export()
	{
		$time = $this->time; 
		$this->date = getdate($time);
		$day = 0;
		$units = 0;
		SQL_BETWEEN( 'month_plus', $time, $day, $units );

		$htm = '<div class="'. $this->class . '" ><table style="width:100%;" cellspacing="0" cellpadding="0">';
		
		if ( $this->showColHeader )
		{ 
			$htm .= "\r\n<tr>";
			if ( $this->showLineHeader )
				$htm .= $this->CornerCell();
			$d = $day;
			for( $line = 0; $line < 7; $line++ )
			{
				$htm .= $this->ColHeaderCell($d);
				$d += 60*60*24;
			}
			$htm .= '</tr>';
		}			
		
		$rows = $units / 7;
		
		for( $row = 0; $row < $rows; $row++ )
		{
			//test
		
			//test ende
		
			$htm .= "\r\n<tr>";
	
			for( $line = 0; $line < 7; $line++ )
			{
				if ( $line == 0 && $this->showLineHeader )
					$htm .= $this->LineHeaderCell($day);
				$htm .= $this->DayCell($day);

				// Das stellt sicher, das der Folgetag immer mit 0:0:0 Beginnt, auch wenn
				// bei der Zeitumstellung der Tag 25 Stunden hat oder 23
				$day += 60*60*27;
				$d = getdate($day);
				$day = mktime(0,0,0, $d['mon'], $d['mday'], $d['year'] );				
			}
			$htm .= '</tr>';	
		}
		$htm .= '</table></div>';
	
		return $htm;
	}
		
	function DayCell($day)
	{
		$d = getdate($day);

		$current = $this->IsCurrentDay($day);
		
		$class = 'day ' . date( 'D', $day ) . ' ';
		if ( $current ) 
			$class .= 'current';
		else
			$class .= (($this->date['mon'] == $d['mon'] )? 'in' : 'out');
			 
		$htm = "<td class=\"$class\" width=\"14%\" valign=\"top\">". 
			$this->DayCellHeader($day, $current). 
			$this->DayCellEvents($day, $current).
			'</td>';
		return $htm;
	}	
	
	function DayCellHeader($day, $current)
	{
		$d = getdate($day);		
		$class = 'dayhdr ' . (($this->date['mon'] == $d['mon'] )? 'dayhdr_in' : 'dayhdr_out');

					
		$txt = $d['mday'];
		if ( $txt == 1 )
 			$txt .= '. ' . Nos::GetString(date( "M", $day ));
		$htm = "<div class=\"$class\">$txt</div>";
		return $htm;
	}	
	
	function DayCellEvents($day, $current)
	{
		$htm = '';
		for ($i = 0; $i < 3; $i++ )
			$htm .= $this->DayCellEvent($day, $current);
		return $htm;
	}	
	
	function DayCellEvent($day, $current)
	{
		$d = getdate($day);		
		$class = 'event ' . (($this->date['mon'] == $d['mon'] )? 'event_in' : 'event_out'); 
		
		$htm = "<div class=\"$class\">" . "Hello World" . '</div>';
		return $htm;
	}	
	
	function LineHeaderCell($day)
	{
		$calendar = NosCalendar::GetInstance();
		$d = getdate($day);
		
		$url = JRoute::_('index.php?option=com_noscalendar&view=calendar&page=week' . $calendar->GetDateURLParams('day', $d['year'], $d['mon'], $d['mday'] ) . $calendar->GetSysParams(true) );
				
		return "<td class=\"linehdr\"><a href=\"$url\"><span>" . date( "W", $day ) . '</span></a></td>';
	}	

	function ColHeaderCell($day)
	{
		$daystring = Nos::GetString(date( "l", $day ));
		if ( $this->showHeaderweekdays )
			$daystring = substr( $daystring, 0, $this->showHeaderweekdays );
	
		return "<th class=\"colhdr\">" . $daystring . '</th>';
	}	
	
	function CornerCell()
	{
		return "<td class=\"corner\"></td>";		
	}
	
}



?>