<?php 
/**
 * @package		NosCalendar
 * @version		1.0.0
 * @copyright	Copyright (C) 2012 Horst Noreick, Inc. All rights reserved.
 * @license		GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

// This Line is required to pass the JEDChecker in Joomla
defined('_JEXEC') or die('Restricted access');
 
 
defined( 'NOS_LIBRARY' ) or die( 'Restricted access' );

// NosCalendarMonthStub ist eine Prototypklasse
// Datenbankspezifische Funktionen m�ssen in
// abgeleiteten Klassen implementiert werden
//


require_once NOSPATH_CALENDAR_HELPERS.DS.'NosCalendarStub.php';

class NosCalendarStubWeek extends NosCalendarStub 
{
	var $showDayHeader 	= true;

	var $showweekend	= true;
	
	function NosCalendarStubWeek()
	{
		$this->class 	= 'noscalendar week';
		$this->orientation	= 'horizontal'; 
		$this->showLineHeader = false;
	}
	function DaysToShow()
	{
		return ($this->showweekend)? 7 : 5;
	}
	
	function Export(  )
	{
		$time = $this->time;
		
		$this->date = getdate($time);
		$day = 0;
		$units = 0;
		SQL_BETWEEN( 'week', $time, $day, $units );

		$htm = "<table style=\"width:100%\" class=\"$this->class\" cellspacing=\"0\" cellpadding=\"0\">";
		
		switch ( $this->orientation )
		{
		case 'horizontal':
			$htm .= $this->ExportHorizontal($day);
			break;
		case 'vertical':
			$htm .= $this->ExportVertical($day);			
			break;
		}
		$htm .= '</table>';
		return $htm;
	}

	function ExportHorizontal( $day )
	{		
		$htm = '';
		$lines = $this->DaysToShow();		
		if ( $this->showColHeader )
		{ 
			$htm .= "\r\n<tr>";
			if ( $this->showLineHeader )
				$htm .= $this->CornerCell();
			$d = $day;
			for( $line = 0; $line < $lines; $line++ )
			{
				$htm .= $this->ColHeaderCell($d);
				$d += 60*60*24;
			}
			$htm .= '</tr>';
		}			
		
		$htm .= "\r\n<tr>";
	

		for( $line = 0; $line < $lines; $line++ )
		{
			if ( $line == 0 && $this->showLineHeader )
				$htm .= $this->LineHeaderCell($day);
			$htm .= $this->DayCell($day);
			
			// Das stellt sicher, das der Folgetag immer mit 0:0:0 Beginnt, auch wenn
			// bei der Zeitumstellung der Tag 25 Stunden hat oder 23
			$day += 60*60*27;
			$d = getdate($day);
			$day = mktime(0,0,0, $d['mon'], $d['mday'], $d['year'] );				
			
		}
		$htm .= '</tr>';	

		return $htm;
	}

	function ExportVertical( $day )
	{		
		$htm = '';
		if ( $this->showColHeader )
		{ 
			$htm .= "\r\n<tr>";
			if ( $this->showLineHeader )
				$htm .= $this->CornerCell();

			$htm .= $this->ColHeaderCell($day);

			$htm .= '</tr>';
		}			
		$lines = $this->DaysToShow();
		for( $line = 0; $line < $lines; $line++ )
		{
			$htm .= "\r\n<tr>";			
			if ( $this->showLineHeader )
				$htm .= $this->LineHeaderCell($day);
			$htm .= $this->DayCell($day);
			
			// Das stellt sicher, das der Folgetag immer mit 0:0:0 Beginnt, auch wenn
			// bei der Zeitumstellung der Tag 25 Stunden hat oder 23
			$day += 60*60*27;
			$d = getdate($day);
			$day = mktime(0,0,0, $d['mon'], $d['mday'], $d['year'] );				

			$htm .= '</tr>';			
		}

		return $htm;
	}
	
	function DayCell($day)
	{
		$d = getdate($day);

		$current = $this->IsCurrentDay( $day );
		
		$class = 'day ';
		if ( $current ) 
			$class .= 'current';
			 
		$width_att = '';			
		if ( $this->orientation == 'horizontal' )
		{			
			$width_val = intval(100 / $this->DaysToShow()) . '%';
			$width_att = "width=\"$width_val\"";
		}
		
		$htm = "<td class=\"$class\" $width_att>";
		if ( $this->showDayHeader ) 
			$htm .= $this->DayCellHeader($day, $current);
		$htm .= $this->DayCellEvents($day, $current);
		$htm .=	'</td>';
		return $htm;
	}	
	
	function DayCellHeader($day, $current)
	{
		$d = getdate($day);		
		$class = 'dayhdr '; 

		$url = JRoute::_('index.php?option=com_noscalendar&view=calendar&page=day' . NosCalendar::GetInstance()->GetDateURLParams('day', $d['year'], $d['mon'], $d['mday'] ) . NosCalendar::GetSysParams(true) );		
		
		$htm = '';
		switch ( $this->orientation )
		{
		case 'horizontal':
			$htm = "<div class=\"$class\"><a href=\"$url\"><span>" . $d['mday'] . '</span></a></div>'; 
			break;
		case 'vertical':
			$date = Nos::GetString(date( "l", $day )).' '. date( "j", $day ) .'.'. date( "n", $day );
		
//			$htm = "<div class=\"$class\">"  . $date .'.</div>';
			$htm = "<div class=\"$class\"><a href=\"$url\"><span>"  . $date .'.</span></a></div>';			
			
			
			break;
		}		
				
		return $htm;
	}	
	
	function DayCellEvents($day, $current)
	{
		$htm = '';
		for ($i = 0; $i < 3; $i++ )
			$htm .= $this->DayCellEvent($day, $current);
		return $htm;
	}	
	
	function DayCellEvent($day, $current)
	{
		$d = getdate($day);		
		$class = 'event '; 
		
		$htm = "<div class=\"$class\">" . "Hello World" . '</div>';
		return $htm;
	}	
	
	function LineHeaderCell($day)
	{
		$htm = '';
		switch ( $this->orientation )
		{
		case 'horizontal':
			$htm .= "<td class=\"linehdr\">" . date( "W", $day ) . '</td>'; 
			break;
		case 'vertical':
			$htm .= "<td class=\"linehdr\">" . date( "j", $day ).'. '. Nos::GetString(date( "D", $day )) . '</td>';			
			break;
		}		
		
		return $htm;
	}	

	function ColHeaderCell($day)
	{
		$htm = '';
		switch ( $this->orientation )
		{
		case 'horizontal':
			$htm .= "<td class=\"colhdr\">" . Nos::GetString(date( "l", $day )) . '</td>'; 
			break;
		case 'vertical':
			$from 	= date( "d. ", $day ) . Nos::GetString( date( "F", $day ) ) . date( " Y", $day );			
			
			$to_day = $day+60*60*24*6;
			$to 	= date( "d. ", $to_day ) . Nos::GetString( date( "F", $to_day ) ) . date( " Y", $to_day );			
			
			$htm .= "<td class=\"colhdr\">" . $from . ' - ' . $to . '</td>';			
			break;
		}		
		
		return $htm;
	}	
	
	function CornerCell()
	{
		return "<td class=\"corner\"></td>";		
	}
	
}



?>