<?php 
/**
 * @package		NosCalendar
 * @version		1.0.0
 * @copyright	Copyright (C) 2012 Horst Noreick, Inc. All rights reserved.
 * @license		GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

// This Line is required to pass the JEDChecker in Joomla
defined('_JEXEC') or die('Restricted access');
 
 
defined( 'NOS_LIBRARY' ) or die( 'Restricted access' );

require_once NOSPATH_CALENDAR_HELPERS.DS.'NosCalendarStubWeek.php';

/* SAMPLE:
 * 
 * 
 * 	
*/

class NosCalendarWeek extends NosCalendarStubWeek
{
	var $event		= 0;
	
	function DayCellEvent($day, $current)
	{
		$event =& $this->event[$this->offset];		
		
		$d = getdate($day);		
		$class = 'event'; 
		if ( $event['clientstate'] )
			$class .= ' clientevent';
		
		$eventurl 	= Nos::Route('index.php?option=com_noscalendar&view=event&eventid=' . $event['eventid'] . '&eventnr=' . $event['eventnr'] );				
		$htm = "<div class=\"$class\"><a href=\"$eventurl\" ><span>" . substr($event['start'], 11, 5) . " - " . $event['summary'] . " </span></a></div>";				
		return $htm;
	}
			
	function DayCellEvents($day, $current)
	{
		$htm = '';
		$day_dbtime = time_to_DBTime( $day );		
		while ( !strncmp( $day_dbtime, $this->event[$this->offset]['start'], 10 ) )
		{
			$htm .= $this->DayCellEvent($day, $current);
			if ( $this->offset >= count( $this->event ) )
				break;
			$this->offset++;
		}
		return $htm;
	}
	
} 


?>