<?php 
/**
 * @package		NosCalendar
 * @version		1.0.0
 * @copyright	Copyright (C) 2012 Horst Noreick, Inc. All rights reserved.
 * @license		GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

// This Line is required to pass the JEDChecker in Joomla
defined('_JEXEC') or die('Restricted access');
  

defined('NOS_LIBRARY') or die;


class NosCalendar_NosCMS extends NosCalendar
{
	function EventURL( $event, $itemid = '', $link_to='' )
	{
		$tmpl = (string)NosRequest::CMD('tmpl');						
		if ( $tmpl )
			$tmpl .= '&tmpl=' . $tmpl;

		// TODO Summary nur bei sef
		$summary = '&summary=' . $this->URLSEGMENT( $event['summary'] );			
			
		if ( $itemid )
			$itemid = '&Itemid=' . $itemid;		
		
		return $this->Route('NosCMS.php?main=calendar&view=event&eventid=' . $event['eventid'] . '&eventnr=' . $event['eventnr'] . $summary.$itemid.$tmpl );
	}
	
	function GetTime()
	{
		static $time = 0;
		if ( !$time )
		{
			$time = time();
			$month 	= NosRequest::CMD( 'month', date( 'n', $time ) );
			$year 	= NosRequest::CMD( 'year', date( 'Y', $time ) );
			$day 	= NosRequest::CMD( 'day', date( 'j', $time ) );
 			$time = mktime(0,0,0,$month, $day, $year);
		}
		return $time;	
	}
	
	function GetParam( $key, $type = 'cmd', $allow_url_param = true, $default = ''   )
	{
		switch ( $type )
		{
			case 'cmd': return NosRequest::CMD( $key, $default );
			case 'int': return NosRequest::INT( $key, $default );
			case 'string':
			case 'city': return NosRequest::CITY( $key, $default );			
		}
		
		return 'NOT_IMPLEMENTED';
	}
	
	
	function Route( $uri )
	{
		return $uri;
	}
}
