function LookForGeoposition(object)
{
	var geo = (window.navigator) ? window.navigator.geolocation : null;
	if ( geo )
		geo.getCurrentPosition(successCallback, errorCallback);
}

function successCallback(position)
{
	var last_char = mypos_url.substr(mypos_url.length -1, mypos_url.length);
	if ( last_char != '?' )
		mypos_url = mypos_url + '&';
	window.location.href = mypos_url + "ccty=mypos&clat=" + position.coords.latitude + "&clon=" + position.coords.longitude;
}

function errorCallback(error) {
	
    var message = "";

    // Check for known errors
    switch (error.code) {
        case error.PERMISSION_DENIED:
            message = "This website does not have permission to use " + 
                      "the Geolocation API";
            break;
        case error.POSITION_UNAVAILABLE:
            message = "The current position could not be determined.";
            break;
        case error.PERMISSION_DENIED_TIMEOUT:
            message = "The current position could not be determined " + 
                      "within the specified timeout period.";            
            break;
    }
    // If it's an unknown error, build a message that includes 
    // information that helps identify the situation, so that 
    // the error handler can be updated.
    if (message == "")
    {
        var strErrorCode = error.code.toString();
        message = "The position could not be determined due to " + 
                  "an unknown error (Code: " + strErrorCode + ").";
    }
    console.log(message);
}
