<?php 
// This Line is required to pass the JEDChecker in Joomla
defined('_JEXEC') or die('Restricted access');

/**
 * NosMicrodata is the baseclass for Microdata implementations. 
 * This Baseclass is used to D_I_S_A_B_L_E Microdata in HTML! Any method
 * will return an empty string; 
 * 
 * 
 */
class NosSemanticWeb
{
	/**
	 * 
	 */
	protected $_event = null;
	static $_personid = null;

	static $eventid = 0;
	static $allow 	= false;		
	
	
	function SetEvent( FastBroadcastCalendarEvent &$e )
	{
		$this->_event = $e;
	}
	
	static function SetPersonID( $id )
	{
		self::$_personid = $id;
	}
	
	function AllowWrite()
	{
		// nothing to do if personid is not defined
		if ( empty(self::$_personid) )
			return true;
		
		// else check for Person involved each event 
		
		if ( self::$eventid != $this->_event->ID() )
		{
			self::$eventid 	= $this->_event->ID();
			self::$allow 	= $this->_event->PersonInvolved( self::$_personid );
		}
		return self::$allow;
	}

	function HideEndDate()
	{
		$hide = false;
		if ( 	$this->_event->End('ymd') != $this->_event->Start('ymd') 
			 && ($this->_event->End() - $this->_event->Start()) < 9 *60*60 
			)
			$hide = true;

		return $hide;
	}
	
	function init_event() 		{ return '';}
	function init_eventvenue()	{ return '';}
	function init_postaladdress() { return '';}
	function init_geocoordinates(){ return '';}
		
	function link_profile()		{return '';}
	
	function city()				{return '';}
	function classname( $classname ){return '';}	
	function description()		{return '';}
	function dtend()			{return '';}
	function dtstart()			{return '';}	
	function image()			{return '';}
	function latitude()			{return '';}	
	function location()			{return '';}
	function longitude()		{return '';}		
	function name()				{return '';}
	function street()			{return '';}	
	function url()				{return '';}
	function zip()				{return '';}
			
	function meta_startdate()	{return '';}
	function meta_enddate()		{return '';}
	function meta_latitude()	{return '';}
	function meta_longitude()	{return '';}
}


class NosHCalendar extends NosSemanticWeb
{
	function link_profile() 
	{ 
		return '<link rel="profile" href="http://microformats.org/profile/hcalendar" />';
	}

	function classname( $classname )
	{
		if ( $this->AllowWrite() )
			return $classname;
		return ''; 
	}	

	function dtstart()	
	{
		if ( $this->AllowWrite() )
		{	
			return '<abbr style="display: none;" class="dtstart" title="'
					. $this->_event->Start(DATE_ISO8601) 
					. '" ></abbr>';
		}
		return '';
	}
	
	function dtend()	
	{
		if ( $this->AllowWrite() && !$this->HideEndDate() )
			return '<abbr style="display: none;" class="dtend" title="'
					. $this->_event->End(DATE_ISO8601) 
					. '" ></abbr>';
		return '';
	}
}


/**
 * 
 * 
 */
class NosSchemaOrg extends NosSemanticWeb
{
	function init_event() 
	{ 
		if ( $this->AllowWrite() )
			return 'itemscope itemtype="http://schema.org/Event"';
		return '';
	}
	
	function init_eventvenue() 
	{
		if ( $this->AllowWrite() )
			return 'itemscope itemtype="http://schema.org/EventVenue"';
		return '';
	}
		
	function init_postaladdress() 
	{
		if ( $this->AllowWrite() ) 
			return 'itemscope itemtype="http://schema.org/PostalAddress"';
		return '';
	}
	
	function init_geocoordinates() 
	{
		if ( $this->AllowWrite() ) 
			return 'itemscope itemtype="http://schema.org/GeoCoordinates"';
		return '';
	}
	
	function city()			{return ($this->AllowWrite())? 'itemprop="addressLocality"' : '';}	
	function description()	{return ($this->AllowWrite())? 'itemprop="description"' : '';}
	function image()		{return ($this->AllowWrite())? 'itemprop="image"' : '';}	
	function latitude()		{return ($this->AllowWrite())? 'itemprop="longitude"' : '';}
	function location()		{return ($this->AllowWrite())? 'itemprop="location"' : '';}
	function longitude()	{return ($this->AllowWrite())? 'itemprop="latitude"' : '';}
	function name()			{return ($this->AllowWrite())? 'itemprop="name"' : '';}
	function street()		{return ($this->AllowWrite())? 'itemprop="streetAddress"' : '';}
	function url()			{return ($this->AllowWrite())? 'itemprop="url"' : '';}
	function zip()			{return ($this->AllowWrite())? 'itemprop="postalCode"' : '';}

	function meta_startdate()	
	{
		if ( $this->AllowWrite() )	
			return '<meta itemprop="startDate" content="'
					. $this->_event->Start(DATE_ISO8601) 
					. '" />';
		return '';
	}
	
	function meta_enddate()	
	{
		if ( $this->AllowWrite() && !$this->HideEndDate() )	
			return '<meta itemprop="endDate" content="'
					. $this->_event->End(DATE_ISO8601) 
					. '" />';
		return '';
	}
	
	function meta_latitude()
	{
		if ( $this->AllowWrite() )
   			return '<meta itemprop="latitude" content="' 
   					. $this->_event->Location()->Latitude()
   					. '" />';
		return '';   				
	}

	function meta_longitude()
	{
		if ( $this->AllowWrite() )	
   			return '<meta itemprop="longitude" content="' 
   					. $this->_event->Location()->Longitude()
   					. '" />';
   		return '';
	}
	
	
}
