<?php
/**
 * @package		NosCalendar
 * @version		1.0.0
 * @copyright	Copyright (C) 2012 Horst Noreick, Inc. All rights reserved.
 * @license		GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

jimport( 'joomla.application.component.model' );

if ( !class_exists('JModelLegacy'))
	require_once NOSPATH_CALENDAR_HELPERS.'/Nos.JModelLegacy.php';
	
class NosCalendarModelCalendar extends JModelLegacy
{

	function EventListParams()
	{
		$calendar = NosCalendar::GetInstance();
		
		$params = array();
		$params['date'] 		= date( "Y-m-d", $calendar->GetTime() );
		$params['catgroups'] 	= $calendar->GetParam( 'catgroups', 'cmdlist', true, 'event' );		
		$params['country']		= $calendar->GetParam( 'country' );		
		
		if ( $calendar->GetParam( 'eventlist_fbattending_position' ) > 0 )
			$params['facebook'] = 'attending';
		
		switch ( $calendar->GetParam( 'selection' ) )
		{
		case 'pool':
			$params['pool'] 		= $calendar->GetParam( 'pool' );
			$calendar->AppendGeoSelectionFields( $params );				
			break;		
		case 'scene':
			$params['scenes'] 		= $calendar->GetParam( 'scene' );
			$calendar->AppendGeoSelectionFields( $params );		
			break;		
		case 'organizer':
			$params['organizerid']	= $calendar->GetParam( 'organizerid' );
			break;
		case 'location':
			$params['locationid']	= $calendar->GetParam( 'locationid' );
			break;						
		}
		return $params;	
	}

	function getMonth()
	{
		$params = $this->EventListParams();
		$params['period'] 		= 'month_plus';
				
		$eventlist = null;
		NosCalendar::GetInstance()->GetEventList( $params, $eventlist );
		return $eventlist;		
	}
		
	function getWeek()
	{
		$params = $this->EventListParams();
		$params['period'] 		= 'week';
		$params['responsegroup']= 'medium';
			
		$eventlist = null;
		NosCalendar::GetInstance()->GetEventList( $params, $eventlist );
		return $eventlist;		
	}

	function getDaylist()
	{
		$params = $this->EventListParams();
		$params['days'] 		= NosCalendar::GetInstance()->GetParam( 'daylist_limit');
		$params['responsegroup']= 'medium';
	
		$eventlist = null;
		NosCalendar::GetInstance()->GetEventList( $params, $eventlist );
		return $eventlist;		
	}
	
	function getHighlight()
	{
		$params = $this->EventListParams();
		$params['state'] 		= 'highlight';
		$params['limit'] 		= NosCalendar::GetInstance()->GetParam( 'highlight_limit');
		
		$limitstart				= NosCalendar::GetInstance()->GetParam( 'limitstart');
		if ( $limitstart > 0 )
			$params['limitstart'] 	= $limitstart; 
		
		$params['responsegroup']= 'medium';
			
		$eventlist = null;
		NosCalendar::GetInstance()->GetEventList( $params, $eventlist );
		return $eventlist;		
	}

	function getComing()
	{
		$params = $this->EventListParams();
		$params['responsegroup']= 'medium';
		$params['limit'] 		= NosCalendar::GetInstance()->GetParam( 'daylist_limit');
		
		$limitstart				= NosCalendar::GetInstance()->GetParam( 'limitstart');
		if ( $limitstart > 0 )
			$params['limitstart'] 	= $limitstart; 
		
		
		$eventlist = null;
		NosCalendar::GetInstance()->GetEventList( $params, $eventlist );
		return $eventlist;		
	}
	
	function getDay()
	{
		$params = $this->EventListParams();
		$params['period'] 		= 'day';
		$params['responsegroup']= 'medium';
			
		$eventlist = null;
		NosCalendar::GetInstance()->GetEventList( $params, $eventlist );
		return $eventlist;		
	}
	
	function getEvent()
	{
		require_once NOSPATH_CALENDAR_HELPERS.DS.'NosCalendarEvent.php';		

		$calendar = NosCalendar::GetInstance();		

		$params = array();
		$params['eventid'] 		= JRequest::getCmd( 'eventid', 0 );
		$params['eventnr'] 		= JRequest::getCmd( 'eventnr', 0 );	
	
		if ( $calendar->GetParam( 'event_show_facebookfeed' ) == '1' )
		{
			$params['facebook'] = 'feed';
		}
		if ( $calendar->GetParam( 'event_show_facebookattending' ) == '1')
		{
			if ( isset( $params['facebook'] ))
				$params['facebook'] .= ',attending';
			else
				$params['facebook'] = 'attending';
		}
		
		$calendar->GetEvent( $params, $event_arr );

		return $event_arr;
	}
	
}
