<?php 

/**
 * @package		NosCalendar
 * @version		1.0.0
 * @copyright	Copyright (C) 2012 Horst Noreick, Inc. All rights reserved.
 * @license		GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

defined('_JEXEC') or die;

if ( !defined('NOS_LIBRARY') )
{
	require_once JPATH_BASE.'/components/com_noscalendar/Nos/Nos.php';
	require_once JPATH_BASE.'/components/com_noscalendar/helpers/NosCalendar.php';		
}

function NosCalendarBuildRoute( &$query )
{
/*
		// debug 
		$txt = '';
		foreach ( $query as $k => $v )
		{
			$txt .= $k . ' = ' . $v . "\r\n";
		}
		$txt .= "\r\n";
		file_put_contents(dirname(__FILE__).'/buildroute.txt', $txt, FILE_APPEND );
		// debug
*/
		

       $segments = array();
	   if ( defined('NOS_APPTYPE') )
	   		return $segments;
       
       if ( isset($query['view']))
       {
       		switch ( $query['view'] )
       		{
       		case 'calendar':
       			if ( NosCalendarRouter::BuildCalendar( $query, $segments ) == NOS_SUCCESS )
    				unset( $query['view'] );       					
       			break;
       		case 'event':
      			if ( NosCalendarRouter::BuildEvent( $query, $segments ) == NOS_SUCCESS )
    				unset( $query['view'] );       					
       			break;
       		case 'eventlist':
      			if ( NosCalendarRouter::BuildEventlist( $query, $segments ) == NOS_SUCCESS )
      			{
//    				unset( $query['view'] );
      			}       					
       			break;
       		}
       }
       else if ( isset($query['target_option']) && isset($query['ccty']))
       {
       		$scene = (isset($query['scene']))? $query['scene'] : 'salsa'; 
       		$segments[] = NosCalendar::GetInstance()->URLSEGMENT( $scene . '-in-' . $query['ccty'] );
//       		unset( $query['target'] );
       		unset( $query['ccty'] );
       } 
              
       return $segments;
}

function NosCalendarParseRoute($segments)
{
	
	$vars = array();
	
	//Get the active menu item.
	$app	= JFactory::getApplication();
	$menu	= $app->getMenu();
	$item	= $menu->getActive();
	
	$view 	= (is_object($item))? $item->query['view'] : '';		
		
	$count = count($segments);
/*
		// debug 
		$txt = '';
		foreach ( $segments as $k => $v )
			$txt .= $k . ' = ' . $v . "\r\n";
		$txt .= "\r\n";		
		file_put_contents(dirname(__FILE__).'/parseroute.txt', $txt, FILE_APPEND );
		
//		file_put_contents(dirname(__FILE__).'/parseroute.txt', ' option='.JRequest::getCmd('option'). ' view='.JRequest::getCmd('view')."\r\n", FILE_APPEND );
		file_put_contents(dirname(__FILE__).'/parseroute.txt', ' view='.$item->query['view']."\r\n", FILE_APPEND );
		
//		file_put_contents(dirname(__FILE__).'/parseroute.txt', ' target='.JRequest::getCmd('target')."\r\n", FILE_APPEND );		
		// debug
 */
	
	$target_option = JRequest::getCmd('target_option','com_noscalendar');
	$segment_0 = strtolower(str_replace( ':','-', $segments[0] ));
	$parts = explode('-', $segment_0 );
	$signatur = NosCalendarRouter::SegmentSignatur( $parts );

	$target_view 	= JRequest::getCmd('target_view');
			
	$retcode = NOS_ERROR;
	if ( strpos( $signatur,'i-i' ) !== false )// Eventsignatur
	{
		$vars['eventid'] 	= $parts[0];
		$vars['eventnr'] 	= $parts[1];
		$vars['view'] 		= ($target_view)? $target_view : 'event';
		$retcode = NOS_SUCCESS;				
	}
	else if ( strpos( $signatur,'scene-catgroup-in' ) !== false )// Eventsignatur
	{
		$catgroup = '';
		NosCalendar::GetInstance()->IsCatgroup($parts[1], $catgroup );
		$parts = explode('-', $segment_0, 4 );
		$vars['scene'] 		= $parts[0];
		$vars['catgroups']	= $catgroup;
		$vars['ccty'] 		= $parts[3];
		$vars['view'] 		= ($target_view)? $target_view : $view;			
		$retcode = NOS_SUCCESS;				
	}
	else if ( strpos( $signatur,'catgroup-at' ) !== false )// Samlpe: Workshops-bei-SalsaHH
	{
		$catgroup = '';
		
//		file_put_contents(dirname(__FILE__).'/parseroute.txt', 'nnnnnnn: '.$parts[2]. "\r\n", FILE_APPEND );
			
		NosCalendar::GetInstance()->IsCatgroup($parts[0], $catgroup );
		$vars['catgroups']	= $catgroup;

		if ( !JRequest::getCmd('selection') )
		{
			if ( JRequest::getInt('organizerid') )
				$vars['selection']	= 'organizer';
			else if ( JRequest::getInt('locationid') )
				$vars['selection']	= 'location';
		}
		if ( !JRequest::getCmd('page') )			
			$vars['page']		= 'coming';		
		
		$vars['view'] 		= ($target_view)? $target_view : $view;			
		$retcode = NOS_SUCCESS;				
	}
	else if ( strpos( $signatur,'scene-in' ) !== false )// Eventsignatur
	{
		$parts = explode('-', $segment_0, 3 );
		$vars['scene'] 		= $parts[0];
		$vars['ccty'] 		= $parts[2];
		$vars['view'] 		= ($target_view)? $target_view : $view;			
		$retcode = NOS_SUCCESS;				
	}

	if ( $target_option != 'com_noscalendar' )
	{
		$url = 	'index.php?option='.$target_option;
		
		if ( isset($vars['view']))
			$url .= '&view='.$vars['view']; 
		if ( isset($vars['scene']))
			$url .= '&scene='.$vars['scene']; 
		if ( isset($vars['catgroups']))
			$url .= '&catgroups='.$vars['catgroups']; 
		if ( isset($vars['ccty']))
			$url .= '&ccty='.$vars['ccty']; 
			
		$app->redirect($url);		
	}		
		
	if ( !isset($vars['view']))
		$vars['view']	= $segments[$count-1];

/*	
	// debug 
	$txt = '';
	foreach ( $vars as $k => $v )
	{

		$txt .= $k . ' = ' . $v . "\r\n";
	}
	
	$txt .= "\r\n";		
	file_put_contents(dirname(__FILE__).'/parseroute.txt', $txt, FILE_APPEND );
	// debug
*/
	
	return $vars;
}



class NosCalendarRouter
{

	static function SegmentSignatur( array $arr )
	{
		$calendar = NosCalendar::GetInstance();	
	
		$signatur = '';
		$join 	  = '';
		foreach ( $arr as $v )
		{
			if ( is_numeric($v) )
				$signatur .= 'i-';
			else if ( is_string($v) )
			{
				if ( $calendar->IsPool( $v ) )
					$signatur .= 'pool-';
				else if ( $calendar->IsCatgroup( $v ) )
					$signatur .= 'catgroup-';
				else if ( $calendar->IsScene( $v ) )
					$signatur .= 'scene-';			
				else if ( $calendar->IsJoin( $v, $join ) )
					$signatur .= $join.'-';
				else 
					$signatur .= 'unknown-';										
			}
		}
		return rtrim($signatur,'-'); 
	}


	function ParseURL()
	{
		$url = parse_url( $_SERVER['REDIRECT_URL'] );
		$parts = explode( '/',$url['path'] );
		
		// The first element will be empty
		array_shift( $parts );
		
		$i = 1;
		$sef_string = strtolower($parts[$i]);
		switch ($sef_string)
		{
			case 'kalender':
			case 'calendar':
				self::ParseCalendar($parts[++$i]);
				break;
		}
	}
	
	static function BuildEvent( &$query, &$segments )
	{
		$retcode = NOS_ERROR;
       	if( isset($query['eventid']) && isset($query['eventnr']) && isset($query['summary']) )
       	{
       		$segments[] = $query['eventid'] . '-' . $query['eventnr'] . '-' . $query['summary'];
            unset( $query['eventid'] );
			unset( $query['eventnr'] );
			unset( $query['summary'] );
			
			$retcode = NOS_SUCCESS;
       	}
		return $retcode;
	}	

	static function ParseEvent( $str, &$params )
	{
		$str = str_replace( ':','-', $str );
		$parts = explode('-', strtolower($str), 3);	
		if (  	isset($parts[0]) && is_numeric( $parts[0] ) 
			&&  isset($parts[1]) && is_numeric( $parts[1] ) )
		{
				$params['eventid'] 	= $parts[0];
				$params['eventnr'] 	= $parts[1];
				$params['view'] 	= 'event';				
				return NOS_SUCCESS;				 				
		}
		return NOS_ERROR;		
	}

	static function ScanWords()
	{
		static $words = null;
		if ( !$words )
		{ 
			define('POOL', 1 );
			define('SCENE', 2 );
			
			define('EVENT', 3 );
			define('WORKSHOP', 4 );
			define('LESSON', 5 );
			
			define('IN', 6 );
			define('BEI', 7 );		
		
			$words = array('salsa'=>SCENE, 'tango'=> SCENE, 'zouk'=>SCENE, 'swing'=>SCENE, 
					'dance'=>POOL,'spirit'=>POOL,
					'event'=>EVENT, 'events'=>EVENT, 'party'=>EVENT, 'parties'=>EVENT, 'partys'=>EVENT, 
					'kurse'=> LESSON, 'kurs'=> LESSON, 'lesson'=> LESSON, 'lessons'=> LESSON, 
					'workshops'=>WORKSHOP, 'workshop'=>WORKSHOP,
					'in'=>IN, 'bei'=>BEI, 'at'=>BEI
			);
		}
		return $words;
	}
	
	static function ParseCalendar( $segments, &$params )
	{
		if ( ($retcode = self::ParseEvent( $segments[0], $params )) == NOS_SUCCESS )
			return $retcode;

		$parts = explode('-', strtolower($segments[0]), 3);

		
		return NOS_ERROR;		
	}
	
	
	static function BuildEventlist( &$query, &$segments )
	{
		$retcode = NOS_ERROR;
       	if( isset($query['scene']) && isset($query['catgroups']) && isset($query['ccty']))
       	{
       		$catgroup = $query['catgroups'];
			switch ( $catgroup )
			{
			case 'event':
				$catgroup = 'Events';
				break;
			case 'workshop':
				$catgroup = 'Workshops';
				break;
			case 'lesson':
				$catgroup = 'Kurse';
				break;
			}

       		$segments[] = ucfirst($query['scene']) . '-' . $catgroup . '-in-' . ucfirst($query['ccty']);
      		
            unset( $query['scene'] );
			unset( $query['catgroups'] );
			unset( $query['ccty'] );
			
			if ( isset($query['summary']))
			{
       			$segments[] = $query['summary'];
				unset( $query['summary'] );
			}       			
       					
			$retcode = NOS_SUCCESS;
       	}
		return $retcode;
	}	
	
	static function ParseEventlist( $str, &$params )
	{
		$words = self::ScanWords();

		$parts = explode('-', strtolower($str), 4);
				
		$i = 0;
		foreach ( $parts as $part )
		{
			if ( isset( $words[$part] ))
			{
				switch ($words[$part])
				{
				case POOL:
					if ( !isset($params['pool']))
						$params['pool'] = $part;
					break;
				case SCENE:
					if ( !isset($params['scene']))				
						$params['scene'] = $part;
					break;
				case EVENT:
					if ( !isset($params['catgroups']))
						$params['catgroup'] = 'event';
					break;
				case LESSON:					
					if ( !isset($params['catgroups']))
						$params['catgroup'] = 'lesson';
					break;
				case WORKSHOP:
					if ( !isset($params['catgroups']))
						$params['catgroup'] = 'workshop';
					break;
				case IN:
					$params['ccty'] 	= $parts[$i+1];
					break;
				case BEI:
					$params['person'] 	= $parts[$i+1];
					break;
				}
			}
			$i++;
		}
		
		return ((count($params) > 2)? NOS_SUCCESS : NOS_ERROR );		
	}
	
	static function BuildCalendar( &$query, &$segments )
	{
		$retcode = NOS_ERROR;
       	if( isset($query['scene']) && isset($query['catgroups']) && isset($query['ccty']))
       	{
       		$catgroup = $query['catgroups'];
			switch ( $catgroup )
			{
			case 'event':
				$catgroup = 'Events';
				break;
			case 'workshop':
				$catgroup = 'Workshops';
				break;
			case 'lesson':
				$catgroup = 'Kurse';
				break;
			}

       		$segments[] = ucfirst($query['scene']) . '-' . $catgroup . '-in-' . ucfirst($query['ccty']);
            unset( $query['scene'] );
			unset( $query['catgroups'] );
			unset( $query['ccty'] );
			$retcode = NOS_SUCCESS;
       	}
		return $retcode;
	}	
	
}
