<?php 
/**
 * @package		NosCalendar
 * @version		1.0.0
 * @copyright	Copyright (C) 2012 Horst Noreick, Inc. All rights reserved.
 * @license		GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

// no direct access
defined('_JEXEC') or die('Restricted access'); 

$e = $this->event_class;

$use_VVK_AK = false;

function FormatMoney( $val )
{
	$val = number_format( $val, 2,',',' ');
	$val = str_replace( ',00', ',-', $val );
	return $val . ' Euro';
	
}
?>




<div class="eventbox cost">
	<div class="title"><?php echo Nos::GetString('TID_PREISE')?></div>
	
	<?php 
	if ( $e->CostFree() > 0 )
	{
		echo '<span class="label">' . Nos::GetString('TID_EINTRITT') . ': </span><span  class="value">' . Nos::GetString('TID_FREI') . '</span>';
	}
	else 
	{	
		$VVK 	= $e->CostVVK();
		$AK 	= $e->CostAK();		
		$done 	= false;
		
		if ( $VVK > 0 )
		{
			echo '<span  class="label">' . Nos::GetString('TID_VVK') . ': </span><span class="value">' . FormatMoney( $e->CostVVK() ) . '</span>';
			$done = true;
		}
		if ( $AK > 0)
		{
			if ( $VVK > 0)
				echo '<br />';
			echo '<span  class="label">' . Nos::GetString('TID_AK') . ': </span><span class="value">' . FormatMoney( $e->CostAK() ) . '</span>';
			$done = true;			
		}

		if ( !$done && $e->CostPerUnit() > 0 )
		{
			echo '<span class="value">' . FormatMoney( $e->CostPerUnit() ) . '</span>';
		}
		
	}
	
	if ( $e->IsCostText() )
	{
		echo '<br /><span class="entry_text">' . $e->CostText() . '</span>';
	}		
	?>
	
	<?php if ( $e->IsCostTable() ) : 
		$costtable = $e->CostTable(); 
	?>
	<table cellspacing="0" cellpadding="0">
		<?php foreach ( $costtable as $row ) :	?>
		
		<tr><th><?php echo $row['COL_1'];?></th><td><?php echo $row['COL_2'];?></td></tr>
		
		<?php endforeach; ?>

	</table>
	<?php endif; ?>
</div>




