<?php 
/**
 * @package		NosCalendar
 * @version		1.0.0
 * @copyright	Copyright (C) 2012 Horst Noreick, Inc. All rights reserved.
 * @license		GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

// no direct access
defined('_JEXEC') or die('Restricted access'); 

$calendar = NosCalendar::GetInstance();

$e			= $this->event_class;
$schema_org	= $this->schema_org;
$hcalendar	= $this->hcalendar;
$location	= $e->Location();
$url		= $location->URL();
?>




<div <?php echo $schema_org->location(); echo $schema_org->init_postaladdress(); ?> class="eventbox eventbox-location">
	<div class="title"><?php echo Nos::GetString('TID_LOCATION')?></div>
	<?php 
	
	if ( $location->IsLogo() )
	{
		if ( $url )
			echo "<a href=\"$url\">";
		echo '<img class="logo" src="' . $location->LogoURL( 1, $calendar->GetParam('event_logo_width') ) . '" alt="" /><br />';		
		if ( $url )
			echo "</a>";
	}	
	?>
	
	<?php 
		if ( $url )
			echo '<a ' . $schema_org->url() . ' href="'. $url . '">';
		echo '<span '. $schema_org->name() .' class="name '. $hcalendar->classname('location') .'">' . $location->FullName() . '</span>';
		if ( $url )
			echo "</a>";
	?>
	<br />
	<?php if ( $location->IsStreet() ) : ?>
		<span <?php echo $schema_org->street();?>><?php echo $location->Street(); ?></span><br />
	<?php endif; ?>
	<?php if ( $location->IsZIP() && $location->IsCity() ) : ?>
		<span <?php echo $schema_org->zip();?>><?php echo $location->ZIP(); ?></span> <span <?php echo $schema_org->city();?>><?php echo $location->City();?></span><br /><br />
	<?php endif; ?>

	<?php if ( $e->ClientState() && $location->IsLongitude() ) : ?>
		<span <?php echo $schema_org->init_geocoordinates();?> >
    		<?php echo $schema_org->meta_latitude().$schema_org->meta_longitude(); ?>
		</span>	
	<?php endif; ?>

</div>

