<?php 
/**
 * @package		NosCalendar
 * @version		1.0.0
 * @copyright	Copyright (C) 2012 Horst Noreick, Inc. All rights reserved.
 * @license		GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

// no direct access
defined('_JEXEC') or die('Restricted access'); 

$e 	= $this->event_class;

$calendar = NosCalendar::GetInstance();

$location = $e->Location();
$logo_url = $location->LogoURL( 1, $calendar->GetParam('event_logo_width') );


$js_toggle_map = <<<JS_TOGGLEMAP

(function($){ window.addEvent('domready', function(){	var e = document.getElementById('location_map'); drawmap();	e.map = 'map'; }) })(document.id);

JS_TOGGLEMAP;

JFactory::getDocument()->addScriptDeclaration( $js_toggle_map );
JFactory::getDocument()->addScript("http://www.openlayers.org/api/OpenLayers.js");
JFactory::getDocument()->addScript("http://www.openstreetmap.org/openlayers/OpenStreetMap.js");
JFactory::getDocument()->addScript("components/com_noscalendar/assets/js/tom.js");
JFactory::getDocument()->addScript("components/com_noscalendar/assets/js/popup.js");

?>

	
<script type="text/javascript"> 	
<!--
function NosToggleMap( id ) 
{
	var e = document.getElementById(id);
	e.style.display = (e.style.display != 'none' ? 'none' : '' );

	if ( e.map == undefined )
	{
		drawmap();
		e.map = 'map';
	}	
}	

var map;
var layer_mapnik;
var layer_tah;
var layer_markers;

// Noreick
// Position und Zoomstufe der Karte
var lon = <?php echo $location->Longitude(); ?>;
var lat = <?php echo $location->Latitude(); ?>;

var zoom = 14;


function drawmap() {
    // Popup und Popuptext mit evtl. Grafik

   	var popuptext="<img class=\"logo\" src=\"<?php echo $logo_url;?>\"><br /><b><?php echo $location->Fullname(); ?></b><br><?php echo $location->Street();?><br><?php echo $location->ZIP().' '.$location->City(); ?>";

//    OpenLayers.Lang.setCode('de');

    map = new OpenLayers.Map('map', {
        projection: new OpenLayers.Projection("EPSG:900913"),
        displayProjection: new OpenLayers.Projection("EPSG:4326"),
        controls: [
//new OpenLayers.Control.MouseDefaults(),
            new OpenLayers.Control.Navigation(),
            new OpenLayers.Control.PanZoomBar()],
//        maxExtent:
//            new OpenLayers.Bounds(-20037508.34,-20037508.34,
//                                    20037508.34, 20037508.34),
        numZoomLevels: 18,
        maxResolution: 156543,
        units: 'meters'
    });

    layer_mapnik = new OpenLayers.Layer.OSM.Mapnik("Mapnik");
//    layer_osmarender = new OpenLayers.Layer.OSM.Mapnik("Osmarender");    
    layer_markers = new OpenLayers.Layer.Markers("Address", { projection: new OpenLayers.Projection("EPSG:4326"), visibility: true, displayInLayerSwitcher: false });

    map.addLayers([layer_mapnik, layer_markers]);
   
        
    jumpTo(lon, lat, zoom);
//    map.setCenter(new OpenLayers.LonLat(lon, lat), zoom);
 
// hier ist ein Beispiel zum setzten von eigenen Markern
// http://m.osmtools.de/index.php?lon=10.307373&lat=48.024792&zoom=6 
    // Position des Markers
    addMarker(layer_markers, lon, lat, popuptext);

}
-->
</script>

<div id="location_map" style=" margin-right: 10px; margin-bottom: 20px;">
  <div id="map" style="height: 323px; ">
  </div>
  	<div style="font-size: 10px; text-align: right;" id="osm">&copy; <a href="http://www.openstreetmap.org">OpenStreetMap</a> und <a href="http://www.openstreetmap.org/copyright">Mitwirkende</a>,
   	<a href="http://creativecommons.org/licenses/by-sa/2.0/deed.de">CC-BY-SA</a>
   	</div>
  	
</div>



