<?php 
/**
 * @package		NosCalendar
 * @version		1.0.0
 * @copyright	Copyright (C) 2012 Horst Noreick, Inc. All rights reserved.
 * @license		GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

// no direct access
defined('_JEXEC') or die('Restricted access'); 

// Dayheader darf nicht event beutzen, weil nicht zwingend für jeden
// Tag ein Event vorhanden ist!!
$day  		= $this->day;

$class		= 'dayhdr';
$calendar 	= NosCalendar::GetInstance();	


$date = Nos::GetString(date( "l", $day )).' '. date( "j", $day ) .'.'. date( "n", $day );


$navigation_show_day = $calendar->GetParam( 'navigation_show_day','int', true, '0');

// if the dayview is not part of the navigation, the day_view cannot be a link target 
if ( $navigation_show_day )
{
	$d		= getdate($day);
	$url 	= JRoute::_('index.php?option=com_noscalendar&view=calendar&page=day' . $calendar->GetDateURLParams('day', $d['year'], $d['mon'], $d['mday'] ) . $calendar->GetSysParams(true) );		
	echo "<div class=\"$class\"><a href=\"$url\"><span>"  . $date .'.</span></a></div>';
}
else 
{
	echo "<div class=\"$class\"><span>"  . $date .'.</span></div>';
}

?>
