<?php // no direct access
/**
 * @package		NosCalendar
 * @version		1.0.0
 * @copyright	Copyright (C) 2012 Horst Noreick, Inc. All rights reserved.
 * @license		GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

defined('_JEXEC') or die('Restricted access'); 

$calendar = NosCalendar::GetInstance();

$e 			= $this->event_class;
$hcalendar 	= $this->hcalendar;
$schema_org	= $this->schema_org;


$class = 'event ' . $hcalendar->classname('vevent'); 
if ( $e->ClientState() )
	$class .= ' clientevent';

if ( $e->IsScene() )
	$class .= ' scn_' . $e->Scene();
	
if ( $e->IsCatgroup() )
	$class .= ' catgrp_' . $e->Catgroup();
	
if ( $e->IsCategory() )
	$class .= ' cat_' . $e->Category();
	
//$class .= ' etpl_' . $this->eventtemplate;
	

/*
	<span class="scene"><?php echo Nos::GetString($e->Scene()); ?></span>			
	<span class="category"><?php echo Nos::GetString($e->Category()); ?></span>
*/

?>

<a name="<?php echo $e->ID().'_'.$e->Nr(); ?>"></a>
<table class="<?php echo $class; ?>">
	<tr>
		<?php 
			if ( $this->image_position == 'col_1' && $this->image_width )
			{ 
				$index = 0;
				$e->IsFlyer($index);
		 		echo 	'<td class="col_1" width="' . $this->image_width .'">' 
		 			. $e->ImageTag( $index, $this->image_width )
		 			. '</td>';
		 	}				
		?>
		
		<?php if ( $this->show_col_2 ) : ?>		
		<td class="col_2">
			<div class="begin"><?php echo $e->Start('H:i'); ?></div>
			<?php 
				$ico_relpath 	= '/components/com_noscalendar/assets/images/ico-'.$e->Scene().'.gif';
				if ( file_exists( JPATH_ROOT . $ico_relpath ) ) :
			?>
			<img class="ico-scene" src="<?php echo JURI::base(). $ico_relpath;?>" width="38" alt="" title=""/>
			<?php endif	?>
			<span class="scene"><?php echo Nos::GetString($e->Scene()); ?></span>			
		</td>
		<?php endif; ?>
				
		<td class="col_3">
		
			<?php 
			echo $hcalendar->dtstart().$hcalendar->dtend();
			echo $schema_org->meta_startdate().$schema_org->meta_enddate();
			
			foreach ( $this->line_positions as $class => $v )
			{
				switch ( $class )
				{
				case 'path':
					echo '<div class="path">' 
							. Nos::GetString($e->Scene())
							. '<span class="path_separator">&nbsp;</span>'
							. Nos::GetString($e->Category()) 
						. '</div>';	
					break;
				case 'summary':
					echo '<h2 class="summary" '. $schema_org->name() .'>'
							. '<a href="' . $calendar->EventURL( $e, JRequest::getInt('Itemid') ) . '">'
								. $e->Summary()
							. '</a>'
						.'</h2>';
					break;
				case 'slogan':
					if ( $e->IsSlogan() )
						echo '<div class="slogan">' . $e->Slogan() . '</div>';
					break;				
				case 'date':				
					echo '<div class="date">'
							. '<span class="city">' . $e->sprintf('{location_city}') . '</span>'
							. '<span class="start">'. $e->sprintf(' {start_d}. {start_F} {start_H}:{start_i}') . '</span>'
							. '<span class="location" '. $schema_org->location() . '>' . $e->sprintf(' &ndash; {location_name}') . '</span>'
						.'</div>';
					break;
				
				}
			}
			?>
			<div class="description">
				<?php 
				//eventlist_description_length
					if ( $this->image_position == 'description' )
					{
						$index = 0;
						$e->IsFlyer($index);
						echo $e->ImageTag( $index, $this->image_width );
					}
					echo $e->Description( 3, 70, '<br />' );	
				?>				
			</div>

			<?php if ( $e->IsFacebook('attending') ) : 
					$fb	= $e->Facebook('attending');						
					$attending 	= $fb['data'];			
			?>
			<div class="fb_attending">
				<?php foreach ( $attending as $item ) : ?>
					<a href="http://www.facebook.com/profile.php?id=<?php echo $item['id'];?>" >
						<img class="profile_pic" src="https://graph.facebook.com/<?php echo $item['id'];?>/picture" />
					</a>
				<?php endforeach; ?>
			</div>
			<?php endif; ?>
			
		</td>
	</tr>
</table>