<?php 
/**
 * @package		NosCalendar
 * @version		1.0.0
 * @copyright	Copyright (C) 2012 Horst Noreick, Inc. All rights reserved.
 * @license		GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

// no direct access
defined('_JEXEC') or die('Restricted access'); 

$calendar = NosCalendar::GetInstance();
		
$eventlist 	= $this->eventlist;
$e 			= $this->event_class;

$days		= $calendar->GetParam( 'daylist_limit','cmd', true, '7' );
$show_days_without_events = $calendar->GetParam('daylist_show_dayswithoutevents');

$event = (count($eventlist))? $eventlist[0] : null;
$e->SetEvent( $event );

$date = $calendar->GetTime();


	
echo '<div class="view_calendar eventlist daylist ' . $this->eventlist_class .'" >';
//for ( $i=0; $i < $days; $i++ )
for ( $i=0; $e->IsValid(); $i++ )
{
	$this->day = $date;

	if ( $e->CompareStart( $date ) || $show_days_without_events )
	{
		$class = ( $e->IsToday() )? ' current' : '';		
		echo '<div class="day'. $class .'" >';		// BEGIN: day
		
		if ( $e->IsValid() && $e->CompareStart( $date ) )		
		{
			if ( $this->show_dayheader )		
				echo $this->loadTemplate( 'eventlist_dayheader' );
			
			if ( $this->show_daymarker )
				echo $this->loadTemplate( 'eventlist_daymarker' );
		
			echo '<div class="event_wrapper">';		// BEGIN: event_wrapper
					
			while ( true )
			{
				echo $this->loadTemplate( $this->eventlist_eventtemplate );

				$e->SetEvent( next( $eventlist ) );
				if ( $e->IsValid() && $e->CompareStart( $date ) )
					echo '<span class="event_separator" >&nbsp;</span>';
				else
					break;		
			}
			
			echo '</div>';							// END: event_wrapper			
		}	
		echo '</div>';								// END: day
		
		if ( $e->IsValid() && !$this->show_dayheader )
			echo '<span class="day_separator" >&nbsp;</span>';	
				
	}	
	$date += 60*60*24;
}
echo '</div>';


