<?php 
/**
 * @package		NosCalendar
 * @version		1.0.0
 * @copyright	Copyright (C) 2012 Horst Noreick, Inc. All rights reserved.
 * @license		GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

// no direct access
defined('_JEXEC') or die('Restricted access'); 

if ( !defined('NOS_APPTYPE') )
{
	$version = new JVersion();
	if ( $version->isCompatible('3.0.0') )
		JHtml::_('behavior.framework');
	else
		JHTML::_('behavior.mootools');
}

$e			= $this->event_class;
$schema_org	= $this->schema_org;
$hcalendar	= $this->hcalendar;
$calendar	= NosCalendar::GetInstance();


$show_modify_date 	= $calendar->GetParam('event_show_modify_date');
$show_hits 			= $calendar->GetParam('event_show_hits');
$show_author 		= $calendar->GetParam('event_show_author');
$event_image_width	= $calendar->GetParam('event_image_width', 'cmd', true, 200);

	
$class = "view_event " . $hcalendar->classname('vevent');
if ( $e->ClientState() )
	$class .= ' clientevent';

if ( $e->IsScene() )
	$class .= ' scn_' . $e->Scene();
	
if ( $e->IsCatgroup() )
	$class .= ' catgrp_' . $e->Catgroup();
	
if ( $e->IsCategory() )
	$class .= ' cat_' . $e->Category();

?>


<div class="<?php echo $class; ?>">
<?php if ( $show_modify_date || $show_hits ) : ?>
	<table width="100%" cellspacing="0" cellpadding="0">
		<tr>
			<td class="uploadinfo">
				<span class="uiButtonText uiButtonTip" title="<?php echo $e->Info(); ?>">#</span>
				<?php //echo Nos::GetString('Hochgeladen von') . ' ' . $event['created_by']. ' ' .Nos::GetString('am') . ' ' . $created . '. '; ?>
				<?php
					if ( $show_modify_date ) 
						echo Nos::GetString('TID_ZULETZT_AKTUALISIERT_VON') . ' ' .  $e->ModifiedBy(). ' ' . Nos::GetString('am') . ' ' .  $e->Modified( 'j.n.Y' ); 
				?>
			</td>
			<td class="hits">
			<?php 
				if ( $show_hits )
					echo Nos::GetString('TID_AUFRUFE') .  ': ' . $e->Hits();
			?>
			</td>		
		</tr>
	</table>
<?php endif; ?>

<?php 	
	if ( $calendar->GetParam('event_show_socialnetworklinks') )
		echo $this->loadTemplate( 'event_social' );
		
	echo $hcalendar->dtstart().$hcalendar->dtend();		
?>
	<div <?php echo $schema_org->name(); ?> class="summary"><?php echo $e->Summary(); ?></div>
	<table width="100%" cellspacing="0" cellpadding="0">
		<tr>
			<td class="data_col" valign="top">
				<?php 
					echo $this->loadTemplate( 'event_date' );
								
					if ( $calendar->GetParam('event_show_location') )
						echo $this->loadTemplate( 'event_location' );
					
				 	echo $this->loadTemplate( 'event_text' );
				 	
				 	if ( $e->IsProgram() )
				 		echo $this->loadTemplate( 'event_program' );
					 					 	
				 	if ( $e->IsDj() )
				 		echo $this->loadTemplate( 'event_dj' );

				 	if ( $e->Guest() )
				 		echo $this->loadTemplate( 'event_guest' );
				 		
				 	if ( $e->CostBoxRequired() )
				 		echo $this->loadTemplate( 'event_cost' );
				 	
				 	if ( $e->Download() )
				 		echo $this->loadTemplate( 'event_download' );				 	

					if ( $calendar->GetParam('event_show_organizer') && $e->IsOrganizer() )
			 			echo $this->loadTemplate( 'event_organizer' );
 				 	
					if ( $e->IsFacebook('feed') )			 			
						echo $this->loadTemplate( 'event_fbfeed' );			 			
			 			
				 ?>			
			</td>	
			<td class="image_col" width="<?php echo $event_image_width;?>" valign="top" >
				<?php  
				if ( $e->Clientstate() )
				{
					if ( $e->IsImage())
					{
						?>
						<div class="eventbox_right images">
							<div class="title"><?php echo Nos::GetString('TID_BILDER')?></div>
						<?php 
						$i = 0;
						while ( $e->IsImage($i))
							echo $e->ImageTag( $i++, $event_image_width, 0, true );						
						?>
						</div>
						<?php 
					}
				}
				
				if ( $e->IsFacebook('attending') )
					echo $this->loadTemplate( 'event_fbattending' );			 			
				
				?>
			</td>	
		</tr>
	</table>
	<?php 
		if ( $e->ClientState() &&  $e->Location()->IsLongitude() )
			echo $this->loadTemplate( 'event_location_map' );
	?>
</div>
