<?php 
/**
 * @package		NosCalendar
 * @version		1.0.0
 * @copyright	Copyright (C) 2012 Horst Noreick, Inc. All rights reserved.
 * @license		GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

// no direct access
defined('_JEXEC') or die('Restricted access'); 

$calendar = NosCalendar::GetInstance();
		
$eventlist 	= $this->eventlist;
$e 			= $this->event_class;

$show_days_without_events = $calendar->GetParam( 'highlight_showdayswithoutevents', 'cmd', true, false );

$currentdate = date( "Y-m-d", time() );

$cursor = 0;
$event = (count($eventlist))? $eventlist[$cursor] : null;
$e->SetEvent( $event );


$date = $calendar->GetTime();
echo '<div class="view_calendar eventlist highlight ' . $this->eventlist_class .'" >';

while ( $event )
{
	$this->day = $date;
	$stringdate = date( "Y-m-d", $date );
	
	$day_has_event = ($stringdate == substr( $event['start'], 0, 10 ))? true : false;
	
	if ( $day_has_event || $show_days_without_events )
	{
		$class = ($stringdate == $currentdate)? ' current' : '';
		echo '<div class="day'. $class .'" >';	// BEGIN: day
		
		if ( $this->show_dayheader )		
			echo $this->loadTemplate( 'eventlist_dayheader' );

		if ( $this->show_daymarker )
			echo $this->loadTemplate( 'eventlist_daymarker' );
			
		echo '<div class="event_wrapper">';		// BEGIN: event_wrapper
					
		while ( $event && $stringdate == substr( $event['start'], 0, 10 ) )
		{
			$e->SetEvent( $event );
			
			echo $this->loadTemplate( $this->eventlist_eventtemplate );			
			
			$event =  isset($eventlist[++$cursor])? $eventlist[$cursor] : null;
			if ( $event && $stringdate == substr( $event['start'], 0, 10 ) )
				echo '<span class="event_separator" >&nbsp;</span>';			
		}	
		
		echo '</div>';							// END: event_wrapper
				
		echo '</div>';							// END: day
		
		if ( $event && !$this->show_dayheader )
			echo '<span class="day_separator" >&nbsp;</span>';			
		
	}	
	$date += 60*60*24;
}
echo '</div>';

/*
echo '<div class="pagination">';
echo $this->pagination->getPagesLinks(  ); //Displays a nice footer
echo '</div>';
*/

?>

