<?php // no direct access
/**
 * @package		NosCalendar
 * @version		1.0.0
 * @copyright	Copyright (C) 2012 Horst Noreick, Inc. All rights reserved.
 * @license		GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

defined('_JEXEC') or die('Restricted access'); 

$calendar = NosCalendar::GetInstance();

$eventlist 	= $this->eventlist;
$e 			= $this->event_class;

$event = (count($eventlist))? $eventlist[0] : null;
$e->SetEvent( $event );

	
$tdate = $calendar->GetTime();

$list_has_event = false;


$date = 0;
$units = 0;
SQL_BETWEEN( 'week', $tdate, $date, $units );
		
echo '<div class="view_calendar eventlist week ' . $this->eventlist_class .'" >';


for ( $i=0; $i < 7; $i++ )
{
	$this->day = $date;
	
	$class = ($e->IsToday())? ' current' : '';
	echo '<div class="day'. $class .'" >';	// BEGIN: day
		
	if ( $e->IsValid() && $e->CompareStart( $date ) )
	{
		if ( $this->show_dayheader )
			echo $this->loadTemplate( 'eventlist_dayheader' );

		if ( $this->show_daymarker )
			echo $this->loadTemplate( 'eventlist_daymarker' );
	
	
		$list_has_event = true;
		echo '<div class="event_wrapper">';	// BEGIN: event_wrapper
	
		while ( true )
		{
			echo $this->loadTemplate( $this->eventlist_eventtemplate );

			$e->SetEvent( next($eventlist) );
			if ( $e->IsValid() && $e->CompareStart( $date ) )
				echo '<span class="event_separator" >&nbsp;</span>';
			else
				break;		
		}

		echo '</div>';						// END: event_wrapper
	}	
	
	echo '</div>';							// END: day
	
	if ( $list_has_event && !$this->show_dayheader && $e->IsValid() )
		echo '<span class="day_separator" >&nbsp;</span>';			
	
	$date += 60*60*24;
}
echo '</div>';

?>