<?php
/**
 * @package		NosCalendar
 * @version		1.0.0
 * @copyright	Copyright (C) 2012 Horst Noreick, Inc. All rights reserved.
 * @license		GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

defined('_JEXEC') or die('Restricted access');
 
jimport( 'joomla.application.component.view');

if ( !class_exists('JViewLegacy'))
	require_once NOSPATH_CALENDAR_HELPERS.'/Nos.JViewLegacy.php';

class NosCalendarViewCalendar extends JViewLegacy
{
	/**
	 * 
	 * @param NosCalendar  
	 */
	function AssignPageVars( NosCalendar &$calendar )
	{
		$event = $calendar->event;
	
		$personlist = (isset( $event['personlist']))?  $event['personlist'] : null;
		if ( $personlist )
		{
			if ( isset( $personlist['location'] ) && isset( $personlist['location'][0] ))
				$this->assignRef( 'location', $personlist['location'][0] );
				
			if ( isset( $personlist['organizer'] ) && isset( $personlist['organizer'][0] ))
				$this->assignRef( 'organizerlist', $personlist['organizer'] );
			
			if ( isset( $personlist['dj'] ) && isset( $personlist['dj'][0] ))
				$this->assignRef( 'djlist', $personlist['dj'] );
		}
	}
	
	/**
	 * 
	 * 
	 * @param 	string 		the name of the page
	 */
	function AssignListVars( $page )
	{
		// coming benutzt die Einstellungen von daylist
		if ($page == 'coming')
			$page = 'daylist';
	
		$calendar	= NosCalendar::GetInstance();
    	$eventlist_eventtemplate	= 'eventlist_event';
		$this->assignRef( 'eventlist_eventtemplate', $eventlist_eventtemplate );
	
		
		$show_col_2 		= $calendar->GetParam( $page . '_show_col_2' );
		$this->assignRef( 'show_col_2', $show_col_2 );
		
		// nur für listen erforderlich!
		$day_marker 			= $calendar->GetParam( $page . '_show_daymarker');
		$show_dayheader 		= ($day_marker == 'horizontal' || $day_marker == 'both');
		$this->assignRef( 'show_dayheader', $show_dayheader );
		
		$show_daymarker 		= ($day_marker == 'vertical' || $day_marker == 'both');
		$this->assignRef( 'show_daymarker', $show_daymarker );
		
		$eventlist_class		= '';
		if ( $show_dayheader )
			$eventlist_class .= ' eventlist_with_dayheader';
		if ( $show_daymarker )
			$eventlist_class .= ' eventlist_with_daymarker';
		$this->assignRef( 'eventlist_class', $eventlist_class );		

		
		$image_position 		= $calendar->GetParam( 'eventlist_image_position');
		$this->assignRef( 'image_position', $image_position );
		
		$image_width 		= $calendar->GetParam( 'eventlist_image_width');
		$this->assignRef( 'image_width', $image_width );
		
		// Detect Line Positions
		$line_positions = array();
		$position 		= $calendar->GetParam( 'eventlist_path_position');
		if ( $position )
			$line_positions['path'] = $position;
		
		$position	= $calendar->GetParam( 'eventlist_summary_position');
		if ( $position )
			$line_positions['summary'] = $position;

		$position	= $calendar->GetParam( 'eventlist_slogan_position');
		if ( $position )
			$line_positions['slogan'] = $position;
							
		$position	= $calendar->GetParam( 'eventlist_date_position');
		if ( $position )
			$line_positions['date'] = $position;

		$position	= $calendar->GetParam( 'eventlist_fbattending_position');
		if ( $position )
			$line_positions['fbattending'] = $position;
			
		asort( $line_positions );
		$this->assignRef( 'line_positions', $line_positions );
		
	}
	
    function SetMetaTags( FastBroadcastCalendarEvent $e )
    {
    	$doc 		= JFactory::getDocument();
    	$title = JFactory::getApplication()->getCfg('sitename') . ' - ' . $e->Summary(); 
    	$doc->setTitle( $title );
    	
    	$description = mb_substr( $e->Description(), 0, 200 ). '...';
    	$doc->setDescription( $description );    	
    }	

    function AppendOpenGraphTags( FastBroadcastCalendarEvent $e )
    {
		$doc 		= JFactory::getDocument();    
		
  		$doc->addCustomTag('<!-- ');
  				
  		$doc->addCustomTag('<meta property="og:title" content="'.$e->Summary().'" />');
  		$doc->addCustomTag('<meta property="og:site_name" content="'.JFactory::getApplication()->getCfg('sitename').'" />');
  		$doc->addCustomTag('<meta property="og:url" content="'. str_replace( '&', '$amp;', JFactory::getURI()->toString() ) . '" />');
		$doc->addCustomTag('<meta property="og:type" content="event" />'); 
		
		if ( $e->ImageName())
		{
			$index = 0;
			$e->IsFlyer($index);
			$imageurl = $e->ImageURL( $index, 200  );
			$doc->addCustomTag('<meta property="og:image" content="' . $imageurl . '" />');			
		}
		
		$location = $e->Location();
		if ( $location )
		{
			$doc->addCustomTag('<meta property="og:fn" content="' . $location->FullName() . '" />');
			$doc->addCustomTag('<meta property="og:street-address" content="' . $location->Street() . '" />');
			$doc->addCustomTag('<meta property="og:postal-code" content="' . $location->Zip() . '" />');
			$doc->addCustomTag('<meta property="og:locality" content="' . $location->City() . '" />');
			$country = $location->Country();
			if ( $country == 'D' )
				$country = 'DE';			 			
			$doc->addCustomTag('<meta property="og:country-name" content="' . $country . '" />');
			
			if ( $e->ClientState() &&  $e->Location()->IsLongitude() )
			{
//				$doc->addCustomTag('<meta property="og:latitude" content="' . $location->Latitude() . '" />');
//				$doc->addCustomTag('<meta property="og:longitude" content="' . $location->Longitude() . '" />');
				
				$doc->addCustomTag('<meta property="og:location:latitude" content="' . $location->Latitude() . '" />');
				$doc->addCustomTag('<meta property="og:location:longitude" content="' . $location->Longitude() . '" />');
			}			
		}
			
		$doc->addCustomTag('<meta property="og:start-time" content="' . $e->Start('Y-m-d') . 'T' . $e->Start('H:i') . '" />');
		$doc->addCustomTag('<meta property="og:end-time" content="' . $e->End('Y-m-d') . 'T' . $e->End('H:i') . '" />');		

/*
		$location = $e->Location();
		if ( $location )
		{
			$doc->addCustomTag('<meta property="og:event:fn" content="' . $location->FullName() . '" />');
			$doc->addCustomTag('<meta property="og:event:street-address" content="' . $location->Street() . '" />');
			$doc->addCustomTag('<meta property="og:event:postal-code" content="' . $location->Zip() . '" />');
			$doc->addCustomTag('<meta property="og:event:locality" content="' . $location->City() . '" />');
			$country = $location->Country();
			if ( $country == 'D' )
				$country = 'DE';			 			
			$doc->addCustomTag('<meta property="og:event:country-name" content="' . $country . '" />');
			
			if ( $e->ClientState() &&  $e->Location()->IsLongitude() )
			{
//				$doc->addCustomTag('<meta property="og:latitude" content="' . $location->Latitude() . '" />');
//				$doc->addCustomTag('<meta property="og:longitude" content="' . $location->Longitude() . '" />');
				
				$doc->addCustomTag('<meta property="og:event:location:latitude" content="' . $location->Latitude() . '" />');
				$doc->addCustomTag('<meta property="og:event:location:longitude" content="' . $location->Longitude() . '" />');
			}			
		}
			
		$doc->addCustomTag('<meta property="og:event:start-time" content="' . $e->Start('Y-m-d') . 'T' . $e->Start('H:i') . '" />');
		$doc->addCustomTag('<meta property="og:event:end-time" content="' . $e->End('Y-m-d') . 'T' . $e->End('H:i') . '" />');		
*/		
		
		
		$description = mb_substr( $e->Description(0,0,''), 0, 400 );
		$sentence = explode( '.', $description );
		if (!empty($sentence) && count($sentence) > 2 )
			array_pop($sentence);
			
		$description = '';
		foreach ( $sentence as $s )
		{
			$s = trim($s);
			if ( (mb_strlen($description) + mb_strlen($s)) > 300 )	
				break;
			$description .= $s . '. ';
		}
		
    	$doc->addCustomTag('<meta property="og:description" content="'.rtrim($description).'"/>');
    	
  		$doc->addCustomTag('-->');    	
    }
	
	/**
	 * 
	 * 
	 */
	function display($tpl = null)
	{
		require_once NOSPATH_CALENDAR_HELPERS.'/FastBroadcast.class.php';
		
		$doc 		= JFactory::getDocument();
		$calendar	= NosCalendar::GetInstance();
		
		FastBroadcast::RegisterTranslationFunction( array('Nos','GetString') );
		$event_class = FastBroadcast::CreateEvent();
		$this->assignRef( 'event_class',$event_class );

		
		// set microdata by schema.org
		$schema_org_state 	= $calendar->GetParam( 'schema_org' );
		$schema_org 		= FastBroadcast::GetSemanticWeb( 'schema.org', ($schema_org_state == 'enabled') );
		
		$event_class->SetSchemaOrg( $schema_org );
		$schema_org->SetEvent( $event_class );
		$this->assignRef( 'schema_org',	$schema_org );
		
		// set microdata by hCalendar
		$hcalendar_state 	= $calendar->GetParam( 'hcalendar' );
		$hcalendar 			= FastBroadcast::GetSemanticWeb( 'hcalendar', ($hcalendar_state == 'enabled') );
		$hcalendar->SetEvent( $event_class );
		$this->assignRef( 'hcalendar',	$hcalendar );
		if ( $hcalendar_state == 'enabled' )
    		JFactory::getDocument()->addCustomTag( $hcalendar->link_profile() );		

		NosSemanticWeb::SetPersonID( $calendar->GetParam( 'semanticweb_personid' ) );    		
    	
		$app	= JFactory::getApplication();	
    	$params = $app->getParams('com_noscalendar');

		$event = null;
		$this->assignRef( 'event', $event );
		
		$day = null;
		$this->assignRef( 'day', $day );
    	
    	
    	// Assign page
		$page = $calendar->GetParam('page');
		if ( empty($page) )
			$page = $params->get('defaultpage', 'month' );
			
    	
    	switch ( $page )
    	{
    	// listviews
    	case 'week':
    	case 'day':
    	case 'highlight':
    	case 'daylist':
    	case 'coming':
			// Get List Data from FastBroadcast
			$eventlist = $this->get( $page );
			$this->assignRef( 'eventlist',	$eventlist );    	
    	
    		$this->AssignListVars( $page );
    		break;

    	// month
    	case 'month':
			// Get List Data from FastBroadcast
			$eventlist = $this->get( $page );
			$this->assignRef( 'eventlist',	$eventlist );
    		break;
    	case 'event':
    		// Get an Event from FastBroadcast
    		$event = $this->get( 'event' );		
    		$event_class->SetEvent( $event );
    		
			$this->SetMetaTags( $event_class );    		
    		$this->AppendOpenGraphTags( $event_class );
		
    		break;    		
    	}
		
    	$this->assignRef( 'page', $page );		
		

		// Assign Navigationbar
		$show_navigationbar = $calendar->GetParam( 'show_navigationbar' );
    	$this->assignRef( 'show_navigationbar', $show_navigationbar );
		
		if ( $this->show_navigationbar )
		{
			$nav_button_option = '';
			if ( $calendar->GetParam('navigation_show_month') != '1' )
				$nav_button_option .= 'no-month';
			if ( $calendar->GetParam('navigation_show_week') != '1' )
				$nav_button_option .= 'no-week';
			if ( $calendar->GetParam('navigation_show_daylist') != '1' )
				$nav_button_option .= 'no-daylist';
			if ( $calendar->GetParam('navigation_show_day') != '1' )
				$nav_button_option .= 'no-daypage';
			if ( $calendar->GetParam('navigation_show_highlight') != '1' )
				$nav_button_option .= 'no-highlight';
				
			$periodButtonParams = $calendar->PeriodButtonParams($page, $nav_button_option );		
			$this->assignRef( 'periodButtonParams', $periodButtonParams );
			
			$periodScrollButtonParams = $calendar->PeriodScrollButtonParams( $page );		
			$this->assignRef( 'periodScrollButtonParams', $periodScrollButtonParams );
		
			$headline = $calendar->Headline( $page, $event );
			$this->assignRef( 'headline', $headline );
		}			
		
			
		
		
		// Script stuff
//		if ( !defined('NOS_APPTYPE') )
		{
			$stylesheet = $calendar->DetectStyleSheet();
			if ( !empty($stylesheet) ) 		
				JFactory::getDocument()->addStyleSheet( $stylesheet );		
		}
		$doc->addScriptDeclaration( $calendar->ButtonTipToolScript() );					
		
		
		$this->pageclass_sfx = htmlspecialchars($params->get('pageclass_sfx'));


		
		
		parent::display($tpl);
	}
}
?>
